/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureGridConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SGFigureElementGrid
extends SGFigureElement
implements SGIFigureElementGrid,
SGILineConstants,
SGIPropertyDialogObserver,
SGIDrawingElementConstants,
SGIFigureGridConstants {
    private SGIFigureElementAxis mAxisElement;
    private SGAxis mXAxis;
    private SGAxis mYAxis;
    private double mStepValueX = 1.0;
    private double mBaselineValueX = 0.0;
    private double mStepValueY = 1.0;
    private double mBaselineValueY = 0.0;
    private boolean mVisibleFlag;
    private boolean mAutoRangeFlag = true;
    private float mLineWidth;
    private int mLineType;
    private Color mColor;
    private int mCap = 0;
    private int mJoin = 1;
    private float mMiterLimit = 1.0f;
    private float mDashPhase = 0.0f;
    private HashSet mLineSet;
    protected SGProperties mTemporaryProperties = null;

    public SGFigureElementGrid() {
        this.init();
    }

    private void init() {
        this.setGridVisible(false);
        this.setAutoRangeFlag(true);
        this.setLineWidth(1.0f, "pt");
        this.setLineType(3);
        this.setColor(DEFAULT_GRID_COLOR);
    }

    public void dispose() {
        super.dispose();
        this.mColor = null;
        this.mXAxis = null;
        this.mYAxis = null;
        this.mAxisElement = null;
        this.mLineSet.clear();
        this.mLineSet = null;
        this.mPressedPoint = null;
        this.mTemporaryProperties = null;
    }

    public String toString() {
        return "SGGridElement";
    }

    public String getClassDescription() {
        return null;
    }

    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    public boolean addData(SGData sGData, String string) {
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGIFigureElementAxis sGIFigureElementAxis = this.mAxisElement;
        if (this.mXAxis == null) {
            this.mXAxis = sGIFigureElementAxis.getAxis("Bottom");
        }
        if (this.mYAxis == null) {
            this.mYAxis = sGIFigureElementAxis.getAxis("Left");
        }
        this.createAll();
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.createAll();
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        HashSet hashSet;
        if (!this.isGridVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = this.mMagnification * this.mLineWidth;
        graphics2D.setPaint(this.getColor());
        BasicStroke basicStroke = SGUtilityJava2D.getBasicStroke(this.mLineType, f, this.mCap, this.mJoin, this.mMiterLimit, this.mDashPhase);
        graphics2D.setStroke(basicStroke);
        if (bl) {
            SGUtilityForFigureElementJava2D.clipGraphRect(this, graphics2D);
        }
        if ((hashSet = this.mLineSet) != null) {
            Iterator iterator = hashSet.iterator();
            if (bl) {
                while (iterator.hasNext()) {
                    Shape shape = (Shape)iterator.next();
                    graphics2D.draw(shape);
                }
            } else {
                Area area = new Area(this.getGraphRect());
                while (iterator.hasNext()) {
                    Shape shape = (Shape)iterator.next();
                    Area area2 = new Area(basicStroke.createStrokedShape(shape));
                    area2.intersect(area);
                    graphics2D.fill(area2);
                }
            }
        }
        if (bl) {
            graphics2D.setClip(this.getViewBounds());
        }
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                this.createAll();
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    private void createAll() {
        HashSet hashSet = new HashSet();
        if (this.isGridVisible()) {
            Set set;
            if (this.mXAxis != null) {
                set = this.create(this.mXAxis, this.mBaselineValueX, true);
                hashSet.addAll(set);
            }
            if (this.mYAxis != null) {
                set = this.create(this.mYAxis, this.mBaselineValueY, false);
                hashSet.addAll(set);
            }
        }
        this.mLineSet = hashSet;
    }

    private Set create(SGAxis sGAxis, double d, boolean bl) {
        int n = sGAxis.getScaleType();
        float[] fArray = null;
        if (n == 0) {
            fArray = this.calcLocationLinear(sGAxis, d, bl);
        } else if (n == 1) {
            fArray = this.calcLocationLog(sGAxis, d, bl);
        } else {
            throw new Error();
        }
        int n2 = fArray.length;
        float f = this.getGraphRectX();
        float f2 = this.getGraphRectY();
        float f3 = this.getGraphRectWidth();
        float f4 = this.getGraphRectHeight();
        HashSet<Line2D.Float> hashSet = new HashSet<Line2D.Float>();
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                float f5 = fArray[i];
                Line2D.Float float_ = new Line2D.Float(f5, f2, f5, f2 + f4);
                hashSet.add(float_);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                float f6 = fArray[i];
                Line2D.Float float_ = new Line2D.Float(f, f6, f + f3, f6);
                hashSet.add(float_);
            }
        }
        return hashSet;
    }

    private float[] calcLocationLinear(SGAxis sGAxis, double d, boolean bl) {
        double d2 = this.mAutoRangeFlag ? this.calcStepValue(sGAxis) : (bl ? Math.abs(this.mStepValueX) : Math.abs(this.mStepValueY));
        double d3 = sGAxis.getMinValue();
        double d4 = sGAxis.getMaxValue();
        HashSet<Double> hashSet = new HashSet<Double>();
        hashSet.add(new Double(d));
        double d5 = d;
        do {
            hashSet.add(new Double(d5 += d2));
        } while (!(d5 > d4));
        d5 = d;
        do {
            hashSet.add(new Double(d5 -= d2));
        } while (!(d5 < d3));
        int n = hashSet.size();
        float[] fArray = new float[n];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Double d6 = (Double)iterator.next();
            fArray[n2] = this.calcLocation(d6, sGAxis, bl);
            ++n2;
        }
        return fArray;
    }

    private float[] calcLocationLog(SGAxis sGAxis, double d, boolean bl) {
        int n;
        int n2;
        double d2 = sGAxis.getRange().x;
        double d3 = sGAxis.getRange().y;
        int n3 = SGUtilityNumber.getOrder(0.99999999999999 * d2);
        int n4 = SGUtilityNumber.getOrder(d3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = n3 + 1; n2 <= n4; ++n2) {
            arrayList.add(new Integer(n2));
        }
        n2 = arrayList.size();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            n = (Integer)arrayList.get(i);
            dArray[i] = SGUtilityNumber.getPowersOfTen(n);
        }
        float[] fArray = new float[n2];
        for (n = 0; n < n2; ++n) {
            fArray[n] = this.calcLocation(dArray[n], sGAxis, bl);
        }
        return fArray;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        return true;
    }

    public SGProperties getProperties() {
        GridProperties gridProperties = new GridProperties();
        if (!this.getProperties(gridProperties)) {
            return null;
        }
        return gridProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GridProperties)) {
            return false;
        }
        GridProperties gridProperties = (GridProperties)sGProperties;
        gridProperties.mXAxis = this.mXAxis;
        gridProperties.mYAxis = this.mYAxis;
        gridProperties.mVisibleFlag = this.mVisibleFlag;
        gridProperties.mBaselineValueX = this.mBaselineValueX;
        gridProperties.mBaselineValueY = this.mBaselineValueY;
        gridProperties.mStepValueX = this.mStepValueX;
        gridProperties.mStepValueY = this.mStepValueY;
        gridProperties.mAutoRangeFlag = this.mAutoRangeFlag;
        gridProperties.mLineWidth = this.mLineWidth;
        gridProperties.mLineType = this.mLineType;
        gridProperties.mColor = this.mColor;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GridProperties)) {
            return false;
        }
        GridProperties gridProperties = (GridProperties)sGProperties;
        this.mXAxis = gridProperties.mXAxis;
        this.mYAxis = gridProperties.mYAxis;
        this.mVisibleFlag = gridProperties.mVisibleFlag;
        this.mBaselineValueX = gridProperties.mBaselineValueX;
        this.mBaselineValueY = gridProperties.mBaselineValueY;
        this.mStepValueX = gridProperties.mStepValueX;
        this.mStepValueY = gridProperties.mStepValueY;
        this.mAutoRangeFlag = gridProperties.mAutoRangeFlag;
        this.mLineWidth = gridProperties.mLineWidth;
        this.mLineType = gridProperties.mLineType;
        this.mColor = gridProperties.mColor;
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    public String getTagName() {
        return "Grid";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("GridVisible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("XAxisPosition", this.mAxisElement.getLocationName(this.mXAxis));
        element.setAttribute("YAxisPosition", this.mAxisElement.getLocationName(this.mYAxis));
        element.setAttribute("AutomaticCalculationOfTick", Boolean.toString(this.mAutoRangeFlag));
        element.setAttribute("StepValueX", Double.toString(this.mStepValueX));
        element.setAttribute("BaselineValueX", Double.toString(this.mBaselineValueX));
        element.setAttribute("StepValueY", Double.toString(this.mStepValueY));
        element.setAttribute("BaselineValueY", Double.toString(this.mBaselineValueY));
        element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
        element.setAttribute("Color", SGUtilityText.getColorString(this.mColor));
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        return false;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        return element;
    }

    public boolean initCompatibleProperty() {
        this.setGridVisible(false);
        this.setAutoRangeFlag(true);
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        if (sGAxis == null) {
            return false;
        }
        if (!this.setXAxis(sGAxis)) {
            return false;
        }
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        if (sGAxis2 == null) {
            return false;
        }
        if (!this.setYAxis(sGAxis2)) {
            return false;
        }
        this.mStepValueX = 1.0;
        this.mBaselineValueX = 0.0;
        this.mStepValueY = 1.0;
        this.mBaselineValueY = 0.0;
        this.setLineWidth(1.0f, "pt");
        this.setLineType(3);
        this.setColor(DEFAULT_GRID_COLOR);
        return true;
    }

    public boolean readProperty(Element element) {
        boolean bl;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl2 = null;
        string = element.getAttribute("GridVisible");
        if (string.length() != 0) {
            bl2 = SGUtilityText.getBoolean(string);
            if (bl2 == null) {
                return false;
            }
            bl = bl2;
            if (!this.setGridVisible(bl)) {
                return false;
            }
        }
        if ((string = element.getAttribute("XAxisPosition")).length() != 0) {
            SGAxis sGAxis = this.mAxisElement.getAxis(string);
            if (sGAxis == null) {
                return false;
            }
            if (!this.setXAxis(sGAxis)) {
                return false;
            }
        }
        if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
            SGAxis sGAxis = this.mAxisElement.getAxis(string);
            if (sGAxis == null) {
                return false;
            }
            if (!this.setYAxis(sGAxis)) {
                return false;
            }
        }
        if ((string = element.getAttribute("AutomaticCalculationOfTick")).length() != 0) {
            bl2 = SGUtilityText.getBoolean(string);
            if (bl2 == null) {
                return false;
            }
            bl = bl2;
            if (!this.setAutoRangeFlag(bl)) {
                return false;
            }
        }
        if ((string = element.getAttribute("BaselineValueX")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setBaselineValueX(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("StepValueX")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setStepValueX(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("BaselineValueY")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setBaselineValueY(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("StepValueY")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setStepValueY(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Width")) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")) != null) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            Color color2 = color;
            if (!this.setColor(color2)) {
                return false;
            }
        }
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    public boolean setChangedFocusedObjects() {
        return true;
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.setChanged(true);
        }
        this.mTemporaryProperties = null;
        this.createAll();
        this.notifyChange();
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.createAll();
        this.notifyChange();
        return true;
    }

    public boolean preview() {
        this.createAll();
        this.notifyChange();
        return true;
    }

    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    public SGPropertyDialog getPropertyDialog() {
        return null;
    }

    public boolean showPropertyDialog() {
        return true;
    }

    public boolean setMementoBackward() {
        if (!super.setMementoBackward()) {
            return false;
        }
        this.createAll();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean setMementoForward() {
        if (!super.setMementoForward()) {
            return false;
        }
        this.createAll();
        this.notifyChangeOnUndo();
        return true;
    }

    public double getBaselineValueX() {
        return this.mBaselineValueX;
    }

    public double getBaselineValueY() {
        return this.mBaselineValueY;
    }

    public Color getColor() {
        return this.mColor;
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public double getStepValueX() {
        return this.mStepValueX;
    }

    public double getStepValueY() {
        return this.mStepValueY;
    }

    public boolean setXAxis(SGAxis sGAxis) {
        this.mXAxis = sGAxis;
        this.createAll();
        return true;
    }

    public boolean setYAxis(SGAxis sGAxis) {
        this.mYAxis = sGAxis;
        this.createAll();
        return true;
    }

    public SGAxis getXAxis() {
        return this.mXAxis;
    }

    public SGAxis getYAxis() {
        return this.mYAxis;
    }

    public boolean setBaselineValueX(double d) {
        this.mBaselineValueX = d;
        this.createAll();
        return true;
    }

    public boolean setBaselineValueY(double d) {
        this.mBaselineValueY = d;
        this.createAll();
        return true;
    }

    public boolean setColor(Color color) {
        this.mColor = color;
        return true;
    }

    public boolean setLineType(int n) {
        if (!SGDrawingElementLine.isValidLineType(n)) {
            return false;
        }
        this.mLineType = n;
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convert(f, string, "pt");
        if (d < 0.25) {
            return false;
        }
        if (d > 6.0) {
            return false;
        }
        return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setStepValueX(double d) {
        if (d == 0.0) {
            return false;
        }
        this.mStepValueX = d;
        this.createAll();
        return true;
    }

    public boolean setStepValueY(double d) {
        if (d == 0.0) {
            return false;
        }
        this.mStepValueY = d;
        this.createAll();
        return true;
    }

    public boolean isGridVisible() {
        return this.mVisibleFlag;
    }

    public boolean setGridVisible(boolean bl) {
        this.mVisibleFlag = bl;
        this.createAll();
        return true;
    }

    public boolean isAutoRange() {
        return this.mAutoRangeFlag;
    }

    public boolean setAutoRangeFlag(boolean bl) {
        this.mAutoRangeFlag = bl;
        return true;
    }

    public int getXAxisLocation() {
        return this.mAxisElement.getLocationInPlane(this.mXAxis);
    }

    public int getYAxisLocation() {
        return this.mAxisElement.getLocationInPlane(this.mYAxis);
    }

    public boolean setXAxisLocation(int n) {
        if (n != 0 & n != 1) {
            return false;
        }
        SGAxis sGAxis = this.getAxis(n);
        if (sGAxis == null) {
            return false;
        }
        this.setXAxis(sGAxis);
        return true;
    }

    public boolean setYAxisLocation(int n) {
        if (n != 2 & n != 3) {
            return false;
        }
        SGAxis sGAxis = this.getAxis(n);
        if (sGAxis == null) {
            return false;
        }
        this.setYAxis(sGAxis);
        return true;
    }

    private SGAxis getAxis(int n) {
        return this.mAxisElement.getAxisInPlane(n);
    }

    public boolean hasValidStepXValue(Number number) {
        double d;
        double d2 = d = number != null ? number.doubleValue() : this.getStepValueX();
        return d != 0.0;
    }

    public boolean hasValidStepYValue(Number number) {
        double d;
        double d2 = d = number != null ? number.doubleValue() : this.getStepValueY();
        return d != 0.0;
    }

    public static class GridProperties
    extends SGProperties {
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private double mStepValueX;
        private double mBaselineValueX;
        private double mStepValueY;
        private double mBaselineValueY;
        private boolean mVisibleFlag;
        private boolean mAutoRangeFlag;
        private float mLineWidth;
        private int mLineType;
        private Color mColor;

        public void dispose() {
            this.mXAxis = null;
            this.mYAxis = null;
            this.mColor = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GridProperties)) {
                return false;
            }
            GridProperties gridProperties = (GridProperties)object;
            if (!this.mXAxis.equals(gridProperties.mXAxis)) {
                return false;
            }
            if (!this.mYAxis.equals(gridProperties.mYAxis)) {
                return false;
            }
            if (this.mBaselineValueX != gridProperties.mBaselineValueX) {
                return false;
            }
            if (this.mStepValueX != gridProperties.mStepValueX) {
                return false;
            }
            if (this.mBaselineValueY != gridProperties.mBaselineValueY) {
                return false;
            }
            if (this.mStepValueY != gridProperties.mStepValueY) {
                return false;
            }
            if (this.mVisibleFlag != gridProperties.mVisibleFlag) {
                return false;
            }
            if (this.mAutoRangeFlag != gridProperties.mAutoRangeFlag) {
                return false;
            }
            if (this.mLineWidth != gridProperties.mLineWidth) {
                return false;
            }
            if (this.mLineType != gridProperties.mLineType) {
                return false;
            }
            return this.mColor.equals(gridProperties.mColor);
        }
    }
}

