#!/bin/sh

original_tag=after_FOXTROT_2_0
branche_tag=HEAD

log_targets="src build lib"

cvsroot=:ext:cvs.sourceforge.jp:/cvsroot/samurai-graph
module=samurai-graph
srcdir=contrib/foxtrot

log=SAMURAIGRAPH-ChangeLog.txt
log_newline=crlf

# define which command
cmd_which () {
  COMMAND="$1"
  OUTPUT=
  IFS=:
  for dir in $PATH
  do
    if test -x "$dir/$COMMAND" ; then
      if test "x$OUTPUT" = "x" ; then
        OUTPUT="$dir/$COMMAND"
      fi
    fi
  done
  echo "$OUTPUT"
}
cmd_error () {
  COMMAND="$1"
  OUTPUT="$2"
  if test -z $OUTPUT; then
    echo "Error: $COMMAND not fould."
    exit
  fi
}

cvs=`cmd_which cvs`
cmd_error cvs $cvs
cvs2cl=`cmd_which cvs2cl`
cmd_error cvs2cl $cvs2cl
diff=`cmd_which diff`
cmd_error diff $diff
cat=`cmd_which cat`
cmd_error cat $cat
unix2dos=`cmd_which unix2dos`
cmd_error unix2dos $unix2dos
dos2unix=`cmd_which dos2unix`
cmd_error dos2unix $dos2unix

# set working directory
current_dir=`dirname $0`
cd $current_dir

# checkout current source
$cvs -z3 -d $cvsroot co -P -r $branche_tag $module/$srcdir > /dev/null 2>&1

tmp=output.diff
files=`(cd $module/$srcdir && ls)`
for i in $files; do
  if test $i != $log && test $i != CVS; then
    (cd $module/$srcdir && $cvs -z3 diff -uN -r $original_tag $i) >> $tmp 2> /dev/null
  fi
done
$dos2unix $tmp

# create change log
(cd $module/$srcdir && $cvs2cl $log_targets) > /dev/null 2>&1

# copy log file
cp $module/$srcdir/ChangeLog $log

# append diff to changelog
$cat $tmp >> $log

test $log_newline = crlf && $unix2dos $log

# cleanup
rm $tmp
rm -rf $module

