package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

/**
 * A dialog with color chooser.
 */
public class SGColorDialog extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1972378173252289790L;

	private JPanel mColorChooserPanel = null;

	private JColorChooser mColorChooser = null;

	private ColorSelectionModel mColorSelectionModel = null;

	/**
	 * This method initializes SGColorDialog form
	 */
	public SGColorDialog(final JDialog parent, final String title,
			final boolean modal) {
		super(parent, title, modal);
		this.initialize();
	}

	/**
	 * get color chooser
	 */
	public JColorChooser getColorChooser() {
		return this.mColorChooser;
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this
				.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		this.setContentPane(this.getMColorChooserPanel());
		// set unresizable
		this.setResizable(false);

	}

	/**
	 * This method initializes mColorChooserPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getMColorChooserPanel() {
		if (this.mColorChooserPanel == null) {
			this.mColorChooserPanel = new JPanel();
			this.mColorChooserPanel.setLayout(new BorderLayout());
			this.mColorChooserPanel.add(this.getMColorChooser(),
					BorderLayout.CENTER);
		}
		return this.mColorChooserPanel;
	}

	/**
	 * This method initializes mColorChooser
	 * 
	 * @return javax.swing.JColorChooser
	 */
	private JColorChooser getMColorChooser() {
		if (this.mColorChooser == null) {
			this.mColorChooser = new JColorChooser();
			// hide the preview panel
			this.mColorChooser.setPreviewPanel(new JPanel());
			// set original color selection model
			this.mColorChooser
					.setSelectionModel(this.getMColorSelectionModel());
		}
		return this.mColorChooser;
	}

	/**
	 * This method initializes mColorSelectionModel
	 * 
	 * @return javax.swing.colorchooser.ColorSelectionModel
	 */
	private ColorSelectionModel getMColorSelectionModel() {
		if (this.mColorSelectionModel == null) {
			this.mColorSelectionModel = new OriginalColorSelectionModel();
		}
		return this.mColorSelectionModel;
	}

	// The original color chooser
	private static class OriginalColorSelectionModel extends
			DefaultColorSelectionModel {

		/**
		 * 
		 */
		private static final long serialVersionUID = -3834864731830390762L;
		private Color selectedColor;

		public OriginalColorSelectionModel() {
			super();
			this.selectedColor = Color.white;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.colorchooser.DefaultColorSelectionModel#getSelectedColor()
		 */
		public Color getSelectedColor() {
			return this.selectedColor;
		}

		// Overrode so as to throw ChangeEvent object
		// even when the input color is equal to the selected color
		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.colorchooser.DefaultColorSelectionModel#setSelectedColor(java.awt.Color)
		 */
		public void setSelectedColor(final Color color) {
			if (color != null) {
				this.selectedColor = color;
				this.fireStateChanged();
			}
		}
	}
}
