
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.JButton;
import javax.swing.border.LineBorder;

/**
 * A button used for the selection of the color.
 */
public class SGColorSelectionButton extends JButton
{

	/**
	 * 
	 */
	private static final long serialVersionUID = -875675138016036356L;

	// a flag whether the color is set to this button
	private boolean mColorSetFlag = true;

	/**
	 * Creates a button.
	 */
	public SGColorSelectionButton()
	{
		super();
		this.setBorder( new LineBorder( Color.BLACK, 1 ) );
	}


	/**
	 * Returns the background color if the color is "set" to this button.
	 * @return Color object is the color is "set", otherwise null.
	 */
	public Color getColor()
	{
		return this.mColorSetFlag ? this.getBackground() : null;
	}


	/**
	 * If the color is set with this method, the color is "set" to this button.
	 * @param cl - color to be set to this button
	 */
	public void setColor( Color cl )
	{
		// if given object is not null, the color is "set"
		this.mColorSetFlag = (cl!=null);

		// set as the background color
		this.setBackground( cl );
	}

	public void paintComponent(Graphics g) {
        super.paintComponent(g);
		if ( g!=null && getModel().isEnabled() ){
            Insets insets=this.getInsets();
            Dimension dimComponent=this.getSize();
            int width=dimComponent.width-(insets.left+insets.right);
            int height=dimComponent.height-(insets.bottom+insets.top);
           	g.setColor(getBackground());    
            g.fillRect(insets.left, insets.top, width, height);
        }
	}
}

