package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 * The class of the file chooser.
 */
public class SGFileChooser extends JFileChooser {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7900924452421491559L;

	// Title of the confirmation dialog.
	private static final String TITLE_CONFIRM_OVERWRITE = "Overwrite Confirmation";

	// Message in the confirmation dialog.
	private static final String MSG_CONFIRM_OVERWRITE = "The file you have selected already exists.\n"
			+ "Overwrite it?";

	/**
	 * 
	 */
	public SGFileChooser() {
		super();
	}

	/**
	 * 
	 * @param currentDirectory
	 */
	public SGFileChooser(File currentDirectory) {
		super(currentDirectory);
	}

	/**
	 * 
	 * @param currentDirectoryPath
	 */
	public SGFileChooser(String currentDirectoryPath) {
		super(currentDirectoryPath);
	}

	/**
	 * Overridden to show confirmation dialog when the file already exists.
	 */
	public void approveSelection() {
		// get the selected file
		File file = this.getSelectedFile();

		if (file != null) {
			//
			// check the file extension
			//

			FileFilter ff = this.getFileFilter();
			if (ff instanceof SGExtensionFileFilter) {
				SGExtensionFileFilter eff = (SGExtensionFileFilter) ff;
				List eList = eff.getExtensionList(); // list of extensions

				String path = file.getAbsolutePath(); // path set to the file
				// chooser
				// if file does not have extension in lists
				// then append selected extension
				final String path_l = path.toLowerCase();
				boolean ext_found = false;
				for (int ii = 0; ii < eList.size(); ii++) {
					String e = (String) eList.get(ii);
					if (path_l.endsWith(e.toLowerCase())) {
						path = path.substring(0, path.length() - e.length())
								+ e;
						ext_found = true;
						break;
					}
				}
				if (!ext_found) {
					path += (String) eList.get(0);
				}
				file = new File(path);
				this.setSelectedFile(file);
			}

			// if selected file already exists
			if (this.getSelectedFile().exists()
					&& this.getDialogType() == JFileChooser.SAVE_DIALOG) {
				// beep
				Toolkit.getDefaultToolkit().beep();

				// show confirmation dialog
				int ret = JOptionPane.showConfirmDialog(this,
						MSG_CONFIRM_OVERWRITE, TITLE_CONFIRM_OVERWRITE,
						JOptionPane.YES_NO_OPTION);
				if (ret == JOptionPane.YES_OPTION) {
					super.approveSelection();
				}
			} else {
				super.approveSelection();
			}
		}
	}

	/**
	 * Overridden not to select directories.
	 * 
	 * @param f -
	 *            file to be set
	 */
	public void setSelectedFile(File f) {
		if (f != null && f.isDirectory()) {
			return;
		}
		super.setSelectedFile(f);
	}

	/**
	 * 
	 */
	public int showDialog(Component parent, String approveButtonText) {
		File old = this.getSelectedFile();
		final int ret = super.showDialog(parent, approveButtonText);
		switch (ret) {
		case JFileChooser.APPROVE_OPTION:
			// selected
			break;
		case JFileChooser.CANCEL_OPTION:
			// canceled
			this.setSelectedFile(old);
			break;
		case JFileChooser.ERROR_OPTION:
			// error
			this.setSelectedFile(old);
			break;
		}

		return ret;
	}

}
