
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;

/**
 * This class provides utility methods for SGFigureElement objects.
 */
public class SGUtilityForFigureElement
{

	public static float getInitialMagnitudePerCM(
		SGIVXYTypeData data, SGIFigureElement el )
	{
		final double[] mArray = data.getMagnitudeArray();
		final float max = (float)SGUtilityNumber.max( mArray );
		final float min = (float)SGUtilityNumber.min( mArray );

		final float size = Math.max( el.getGraphRectWidth(), el.getGraphRectHeight() );
		final float len = 0.10f*size;

//		final float factor = len/max;
		final float percm = max/(len*SGIConstants.CM_POINT_RATIO);
		final float percmReduced = min==max ? percm : (float)SGUtilityNumber.getNumberInRangeOrder( percm, min, max, 3 );

		return percmReduced;
	}


//	public static void main(String[] args)
//	{
//	}
}

