
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;

/**
 * A dialog to set the properties of arrows.
 */
public class SGArrowDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 369310544895101136L;
	/**
	 * 
	 */
	public static final String TITLE = "Arrow Properties";

    
    /** Creates new form SGArrowDialog */
    public SGArrowDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
		this.initProperty();
		this.initialize();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mFormLabel = new javax.swing.JLabel();
        mFormSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mArrowPanelContainer = new javax.swing.JPanel();
        mLocationPanel = new javax.swing.JPanel();
        mLeftXValueLabel = new javax.swing.JLabel();
        mStartXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mRightXValueLabel = new javax.swing.JLabel();
        mEndXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLeftYValueLabel = new javax.swing.JLabel();
        mStartYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mRightYValueLabel = new javax.swing.JLabel();
        mEndYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mRightSpaceLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFormLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormLabel.setText("Form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFormLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mPanel.add(mFormSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 4, 5, 5);
        mPanel.add(mLocationSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mPanel.add(mArrowPanelContainer, gridBagConstraints);

        mLocationPanel.setLayout(new java.awt.GridBagLayout());

        mLeftXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftXValueLabel.setText("Start X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLocationPanel.add(mLeftXValueLabel, gridBagConstraints);

        mStartXValueTextField.setColumns(6);
        mStartXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLocationPanel.add(mStartXValueTextField, gridBagConstraints);

        mRightXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightXValueLabel.setText("End X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mLocationPanel.add(mRightXValueLabel, gridBagConstraints);

        mEndXValueTextField.setColumns(6);
        mEndXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLocationPanel.add(mEndXValueTextField, gridBagConstraints);

        mLeftYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftYValueLabel.setText("Start Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLocationPanel.add(mLeftYValueLabel, gridBagConstraints);

        mStartYValueTextField.setColumns(6);
        mStartYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLocationPanel.add(mStartYValueTextField, gridBagConstraints);

        mRightYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightYValueLabel.setText("End Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mLocationPanel.add(mRightYValueLabel, gridBagConstraints);

        mEndYValueTextField.setColumns(6);
        mEndYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLocationPanel.add(mEndYValueTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        mPanel.add(mLocationPanel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        mPanel.add(mRightSpaceLabel, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    

    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mArrowPanelContainer;
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mEndXValueTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mEndYValueTextField;
    private javax.swing.JLabel mFormLabel;
    private javax.swing.JSeparator mFormSeparator;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLeftXValueLabel;
    private javax.swing.JLabel mLeftYValueLabel;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JPanel mLocationPanel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mRightXValueLabel;
    private javax.swing.JLabel mRightYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mStartXValueTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mStartYValueTextField;
    // ϐ錾̏I//GEN-END:variables


	// a panel to set arrow properties
	private SGArrowPanel mArrowPanel = null;


	// the initialization method
	private void initProperty()
	{

		// set the title
		this.setTitle( TITLE );

		this.mArrowPanel = new SGArrowPanel();
		this.mArrowPanelContainer.add( this.mArrowPanel );

		this.pack();


		// set the name
		this.mStartXValueTextField.setDescription("Location-> StartX");
		this.mStartYValueTextField.setDescription("Location-> StartY");
		this.mEndXValueTextField.setDescription("Location-> EndX");
		this.mEndYValueTextField.setDescription("Location-> EndY");

		
		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);
		this.mPreviewButton.addActionListener(this);
	}


//	/**
//	 * 
//	 */
//	public void dispose()
//	{
//		if( this.mArrowPanel!=null )
//		{
//			this.mArrowPanel.dispose();
//			this.mArrowPanel = null;
//		}
//		
//		super.dispose();
//	}


	/**
	 * 
	 */
	public List getColorSelectionButtonsList()
	{
		final List list = new ArrayList();
		list.addAll( this.mArrowPanel.getColorSelectionButtonsList() );
		return list;
	}


	/**
	 * 
	 */
	public List getTextFieldComponentsList()
	{
		final List list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public List getNumberTextFieldList()
	{
		final List list = new ArrayList();
		list.add( this.mStartXValueTextField );
		list.add( this.mEndXValueTextField );
		list.add( this.mStartYValueTextField );
		list.add( this.mEndYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public List getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.addAll( this.mArrowPanel.getSpinnerList() );
		return list;
	}



	/**
	 * 
	 * @param l
	 * @return
	 */
	public boolean addPropertyDialogObserver(
		final SGIPropertyDialogObserver l )
	{
		super.addPropertyDialogObserver(l);
		if( l instanceof SGIArrowPanelObserver )
		{
			this.mArrowPanel.addObserver( (SGIArrowPanelObserver)l );
		}
		return true;
	}


	/**
	 * 
	 * @param l
	 * @return
	 */
	public boolean removePropertyDialogObserver(
		final SGIPropertyDialogObserver l )
	{
		super.removePropertyDialogObserver(l);
		if( l instanceof SGIArrowPanelObserver )
		{
			this.mArrowPanel.removeObserver( (SGIArrowPanelObserver)l );
		}
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean removeAllPropertyDialogObserver()
	{
		super.removeAllPropertyDialogObserver();
		this.mArrowPanel.removeAllObserver();
		return true;
	}



	/**
	 * 
	 * @param value
	 */
	public boolean setStartXValue( final Object obj )
	{
		return this.setValue( this.mStartXValueTextField, obj );
	}


	/**
	 * 
	 * @param value
	 */
	public boolean setStartYValue( final Object obj )
	{
		return this.setValue( this.mStartYValueTextField, obj );
	}


	/**
	 * 
	 * @param value
	 */
	public boolean setEndXValue( final Object obj )
	{
		return this.setValue( this.mEndXValueTextField, obj );
	}


	/**
	 * 
	 * @param value
	 */
	public boolean setEndYValue( final Object obj )
	{
		return this.setValue( this.mEndYValueTextField, obj );
	}



	/**
	 * 
	 * @return
	 */
	public Number getStartXValue()
	{
		return this.getNumber( this.mStartXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getStartYValue()
	{
		return this.getNumber( this.mStartYValueTextField );
	}


	/**
	 * 
	 * @return
	 */
	public Number getEndXValue()
	{
		return this.getNumber( this.mEndXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getEndYValue()
	{
		return this.getNumber( this.mEndYValueTextField );
	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
		List list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}

		// set to the arrow panel
		if( this.mArrowPanel.setComponentsProperty() == false )
		{
			return false;
		}


		SGIArrowDialogObserver arrow0
			= (SGIArrowDialogObserver)list.get(0);

		final double startXValue0 = arrow0.getStartXValue();
		final double startYValue0 = arrow0.getStartYValue();
		final double endXValue0 = arrow0.getEndXValue();
		final double endYValue0 = arrow0.getEndYValue();

		Double startXValue = new Double( startXValue0 );
		Double startYValue = new Double( startYValue0 );
		Double endXValue = new Double( endXValue0 );
		Double endYValue = new Double( endYValue0 );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowDialogObserver arrow1
					= (SGIArrowDialogObserver)list.get(ii);
				final double xValue1 = arrow1.getStartXValue();
				if( startXValue0!=xValue1 )
				{
					startXValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowDialogObserver arrow1
					= (SGIArrowDialogObserver)list.get(ii);
				final double yValue1 = arrow1.getStartYValue();
				if( startYValue0!=yValue1 )
				{
					startYValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowDialogObserver arrow1
					= (SGIArrowDialogObserver)list.get(ii);
				final double xValue1 = arrow1.getEndXValue();
				if( endXValue0!=xValue1 )
				{
					endXValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowDialogObserver arrow1
					= (SGIArrowDialogObserver)list.get(ii);
				final double yValue1 = arrow1.getEndYValue();
				if( endYValue0!=yValue1 )
				{
					endYValue = null;
					break;
				}
			}
		}


		//
		this.setStartXValue( startXValue );
		this.setStartYValue( startYValue );
		this.setEndXValue( endXValue );
		this.setEndYValue( endYValue );
		

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGIArrowDialogObserver arrow = (SGIArrowDialogObserver)l;


		// get values
		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();
		final Number startX = this.getStartXValue();
		final Number startY = this.getStartYValue();
		final Number endX = this.getEndXValue();
		final Number endY = this.getEndYValue();

		final ArrayList list = new ArrayList();
		if( arrow.hasValidStartXValue( xConfig, startX ) == false )
		{
			list.add("StartX");
		}
		if( arrow.hasValidStartYValue( yConfig, startY ) == false )
		{
			list.add("StartY");
		}
		if( arrow.hasValidEndXValue( xConfig, endX ) == false )
		{
			list.add("EndX");
		}
		if( arrow.hasValidEndYValue( yConfig, endY ) == false )
		{
			list.add("EndY");
		}
		if( list.size()!=0 )
		{
			String msg = ERRMSG_AXIS_VALUE_INVALID + ":\n";
			for( int ii=0; ii<list.size(); ii++ )
			{
				String str = (String)list.get(ii);
				msg += "- " + str + "\n";
			}
			this.setInputErrorMessage(msg);
			return false;
		}


		// set the related axes
		if( xConfig!=-1 )
		{
			arrow.setXAxisLocation( xConfig );
		}

		if( yConfig!=-1 )
		{
			arrow.setYAxisLocation( yConfig );
		}


		if( startX!=null )
		{
			arrow.setStartXValue( startX.doubleValue() );
		}

		if( startY!=null )
		{
			arrow.setStartYValue( startY.doubleValue() );
		}

		if( endX!=null )
		{
			arrow.setEndXValue( endX.doubleValue() );
		}

		if( endY!=null )
		{
			arrow.setEndYValue( endY.doubleValue() );
		}


		// set with the arrow panel
		if( this.mArrowPanel.setPropertiesToListeners( (SGIArrowPanelObserver)arrow ) == false )
		{
			final String msg = this.mArrowPanel.getInputErrorMessage();
			if( msg!=null )
			{
				this.setInputErrorMessage( msg );
			}
			return false;
		}

		return true;
	}


}

