/*
 * SGArrowPanel.java
 *
 * Created on 2005/05/23, 18:11
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyPanel;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;

/**
 * @author   kuromaru
 */
public class SGArrowPanel extends SGPropertyPanel
	implements SGIFigureDrawingElementConstants, SGIArrowConstants
{

	/**
	 * 
	 */
	private static final long serialVersionUID = -9105514967167799562L;
	public static final String MSG_ANGLE_ERROR
		= "Open angle must be smaller than close angle.";

    
    /** Creates new form SGArrowPanel */
    public SGArrowPanel()
    {
    	super();
        initComponents();
        this.initProperty();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mHeadSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mHeadSizeLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mCloseAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mCloseAngleLabel = new javax.swing.JLabel();
        mOpenAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mOpenAngleLabel = new javax.swing.JLabel();
        mStartHeadTypeLabel = new javax.swing.JLabel();
        mStartHeadTypeComboBox = new javax.swing.JComboBox();
        mEndHeadTypeLabel = new javax.swing.JLabel();
        mEndHeadTypeComboBox = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        mHeadSizeSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeadSizeSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mHeadSizeSpinner, gridBagConstraints);

        mHeadSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeadSizeLabel.setText("Head Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mHeadSizeLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        add(mColorLabel, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mColorButton, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        add(mLineWidthLabel, gridBagConstraints);

        mLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mLineWidthSpinner, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Line Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 5, 5);
        add(mLineTypeLabel, gridBagConstraints);

        mLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(140, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        add(mLineTypeComboBox, gridBagConstraints);

        mCloseAngleSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mCloseAngleSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(mCloseAngleSpinner, gridBagConstraints);

        mCloseAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mCloseAngleLabel.setText("Close Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(mCloseAngleLabel, gridBagConstraints);

        mOpenAngleSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mOpenAngleSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(mOpenAngleSpinner, gridBagConstraints);

        mOpenAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mOpenAngleLabel.setText("Open Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(mOpenAngleLabel, gridBagConstraints);

        mStartHeadTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStartHeadTypeLabel.setText("Start Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(mStartHeadTypeLabel, gridBagConstraints);

        mStartHeadTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mStartHeadTypeComboBox.setPreferredSize(new java.awt.Dimension(150, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(mStartHeadTypeComboBox, gridBagConstraints);

        mEndHeadTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mEndHeadTypeLabel.setText("End Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(mEndHeadTypeLabel, gridBagConstraints);

        mEndHeadTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mEndHeadTypeComboBox.setPreferredSize(new java.awt.Dimension(150, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(mEndHeadTypeComboBox, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mCloseAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mCloseAngleSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mColorButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JComboBox mEndHeadTypeComboBox;
    private javax.swing.JLabel mEndHeadTypeLabel;
    private javax.swing.JLabel mHeadSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mHeadSizeSpinner;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mOpenAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mOpenAngleSpinner;
    private javax.swing.JComboBox mStartHeadTypeComboBox;
    private javax.swing.JLabel mStartHeadTypeLabel;
    // ϐ錾̏I//GEN-END:variables



	public static final double ARROW_HEAD_SIZE_STEP = 0.05;
	public static final double ARROW_HEAD_ANGLE_STEP = 1.0;



	//
	private void initProperty()
	{

		//
		{
			final String typeArray[] = {
				SGILineConstants.LINE_NAME_SOLID,
				SGILineConstants.LINE_NAME_BROKEN,
				SGILineConstants.LINE_NAME_DOT,
				SGILineConstants.LINE_NAME_DASHED,
				SGILineConstants.LINE_NAME_DOUBLE_DASHED
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mLineTypeComboBox.addItem( typeArray[ii] );
			}
		}


		//
		{
			final Object typeArray[] = {
				SGIArrowConstants.SYMBOL_NAME_ARROW_HEAD,
				SGISymbolConstants.SYMBOL_NAME_CIRCLE,
				SGISymbolConstants.SYMBOL_NAME_TRIANGLE,
				SGISymbolConstants.SYMBOL_NAME_INVERTED_TRIANGLE,
				SGISymbolConstants.SYMBOL_NAME_SQUARE,
				SGISymbolConstants.SYMBOL_NAME_DIAMOND,
				SGISymbolConstants.SYMBOL_NAME_TRANSVERSE_LINE,
				SGISymbolConstants.SYMBOL_NAME_CROSS,
				SGISymbolConstants.SYMBOL_NAME_VOID
			};

			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mStartHeadTypeComboBox.addItem( typeArray[ii] );
				this.mEndHeadTypeComboBox.addItem( typeArray[ii] );
			}
		}


		//
		// spinner model
		//

		// line width
		this.mLineWidthSpinner.initProperties(
			SGPropertyDialog.getLineWidthSpinnerNumberModel(),
			LINE_WIDTH_UNIT, 1, 2 );

		// head size
		this.mHeadSizeSpinner.initProperties(
			new SpinnerNumberModel(
				0.1, ARROW_HEAD_SIZE_MIN, ARROW_HEAD_SIZE_MAX, ARROW_HEAD_SIZE_STEP ),
				ARROW_HEAD_SIZE_UNIT, 1, 2 );

		// angle
		this.mOpenAngleSpinner.initProperties(
			new SpinnerNumberModel(
				10.0, ARROW_HEAD_OPEN_ANGLE_MIN, ARROW_HEAD_OPEN_ANGLE_MAX, ARROW_HEAD_ANGLE_STEP ),
			degree, 1, 2 );

		this.mCloseAngleSpinner.initProperties(
			new SpinnerNumberModel(
				10.0, ARROW_HEAD_CLOSE_ANGLE_MIN, ARROW_HEAD_CLOSE_ANGLE_MAX, ARROW_HEAD_ANGLE_STEP ),
			degree, 1, 2 );


		// set the name
		this.mLineWidthSpinner.setDescription("Form-> Line Width");
		this.mHeadSizeSpinner.setDescription("Form-> Head Size");
		this.mOpenAngleSpinner.setDescription("Form-> Open Angle");
		this.mCloseAngleSpinner.setDescription("Form-> Close Angle");
	}




	/**
	 * 
	 */
	public void dispose()
	{
		super.dispose();
		this.mObserverList.clear();
		this.mObserverList = null;
	}


	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		list.add( this.mHeadSizeSpinner );
		list.add( this.mOpenAngleSpinner );
		list.add( this.mCloseAngleSpinner );
		return list;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	protected boolean setValue(
		final SGTextField tf, final Object obj )
	{
		return SGUtility.setValue(tf,obj);
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	protected boolean setValue(
		final SGSpinner sp, final Object obj )
	{
		return SGUtility.setValue(sp,obj);
	}



	/**
	 * 
	 */
	private ArrayList mObserverList = new ArrayList();


	/**
	 * 
	 * @param l
	 * @return
	 */
	public boolean addObserver(
		final SGIArrowPanelObserver l )
	{
		this.mObserverList.add(l);
		return true;
	}


	/**
	 * 
	 * @param l
	 * @return
	 */
	public boolean removeObserver(
		final SGIArrowPanelObserver l )
	{
		this.mObserverList.remove(l);
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean removeAllObserver()
	{
		this.mObserverList.clear();
		return true;
	}



	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Integer getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		if( typeName==null )
		{
			return null;
		}
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		return num;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.mColorButton.getColor();
	}


	/**
	 * 
	 */
	public Number getHeadSize()
	{
		return this.mHeadSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Integer getStartHeadType()
	{
		final String typeName = (String)this.mStartHeadTypeComboBox.getSelectedItem();
		if( typeName==null )
		{
			return null;
		}
		final Integer num = SGDrawingElementArrow.getSymbolTypeFromName( typeName );
		return num;
	}


	/**
	 * 
	 */
	public Integer getEndHeadType()
	{
		final String typeName = (String)this.mEndHeadTypeComboBox.getSelectedItem();
		if( typeName==null )
		{
			return null;
		}
		final Integer num = SGDrawingElementArrow.getSymbolTypeFromName( typeName );
		return num;
	}


	/**
	 * 
	 */
	public Number getHeadOpenAngle()
	{
		return this.mOpenAngleSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getHeadCloseAngle()
	{
		return this.mCloseAngleSpinner.getNumber();
	}



	/**
	 * 
	 */
	public boolean setLineWidth( final Object obj )
	{
		return this.setValue( this.mLineWidthSpinner, obj );
	}


	/**
	 * 
	 */
	public boolean setLineType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementLine.getLineTypeName( type.intValue() );
			this.mLineTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mLineTypeComboBox.setSelectedItem( null );
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		this.mColorButton.setColor( cl );
		return true;
	}



	/**
	 * 
	 */
	public boolean setStartHeadType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementArrow.getSymbolTypeName( type.intValue() );
			this.mStartHeadTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mStartHeadTypeComboBox.setSelectedItem(null);
		}
		return true;
	}



	/**
	 * 
	 */
	public boolean setEndHeadType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementArrow.getSymbolTypeName( type.intValue() );
			this.mEndHeadTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mEndHeadTypeComboBox.setSelectedItem(null);
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setHeadSize( final Object obj )
	{
		return this.setValue( this.mHeadSizeSpinner, obj );
	}


	/**
	 * 
	 */
	public boolean setOpenAngle( final Object obj )
	{
		return this.setValue( this.mOpenAngleSpinner, obj );
	}


	/**
	 * 
	 */
	public boolean setCloseAngle( final Object obj )
	{
		return this.setValue( this.mCloseAngleSpinner, obj );
	}



	/**
	 * 
	 * @return
	 */
	public boolean setComponentsProperty()
	{
		ArrayList list = this.mObserverList;

		SGIArrowPanelObserver arrow0
			= (SGIArrowPanelObserver)list.get(0);

		final float lineWidth0 = arrow0.getLineWidth( pt );
		final int lineType0 = arrow0.getLineType();
		final Color color0 = arrow0.getColor();
		final float headSize0 = arrow0.getHeadSize( cm );
		final int startType0 = arrow0.getStartHeadType();
		final int endType0 = arrow0.getEndHeadType();
		final float openAngle0 = arrow0.getHeadOpenAngle();
		final float closeAngle0 = arrow0.getHeadCloseAngle();

		Float lineWidth = new Float( lineWidth0 );
		Integer lineType = new Integer( lineType0 );
		Color color = color0;
		Float headSize = new Float( headSize0 );
		Integer startType = new Integer( startType0 );
		Integer endType = new Integer( endType0 );
		Float openAngle = new Float( openAngle0 );
		Float closeAngle = new Float( closeAngle0 );


		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final float lineWidth1 = arrow1.getLineWidth( pt );
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final int lineType1 = arrow1.getLineType();
				if( lineType0!=lineType1 )
				{
					lineType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final Color color1 = arrow1.getColor();
				if( color0.equals(color1) == false )
				{
					color = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final float headSize1 = arrow1.getHeadSize( cm );
				if( headSize0!=headSize1 )
				{
					headSize = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final int startType1 = arrow1.getStartHeadType();
				if( startType0!=startType1 )
				{
					startType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final int endType1 = arrow1.getEndHeadType();
				if( endType0!=endType1 )
				{
					endType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final float openAngle1 = arrow1.getHeadOpenAngle();
				if( openAngle0!=openAngle1 )
				{
					openAngle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIArrowPanelObserver arrow1
					= (SGIArrowPanelObserver)list.get(ii);
				final float closeAngle1 = arrow1.getHeadCloseAngle();
				if( closeAngle0!=closeAngle1 )
				{
					closeAngle = null;
					break;
				}
			}

		}


		//
		this.setLineWidth( lineWidth );
		this.setLineType( lineType );
		this.setColor( color );

//		if( headSize!=null )
//		{
//			headSize = new Float( headSize.floatValue()*CM_POINT_RATIO );
//		}
		this.setHeadSize( headSize );

		this.setStartHeadType( startType );
		this.setEndHeadType( endType );

		if( openAngle!=null )
		{
			openAngle = new Float( openAngle.floatValue()/RADIAN_DEGREE_RATIO );
		}
		this.setOpenAngle( openAngle );

		if( closeAngle!=null )
		{
			closeAngle = new Float( closeAngle.floatValue()/RADIAN_DEGREE_RATIO );
		}
		this.setCloseAngle( closeAngle );


		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIArrowPanelObserver l )
	{
		final float rd = RADIAN_DEGREE_RATIO;

		// get values
		final Number lineWidth = this.getLineWidth();
		final Integer lineType = this.getLineType();
		final Number headSize = this.getHeadSize();
		final Color color = this.getColor();
		final Integer startType = this.getStartHeadType();
		final Integer endType = this.getEndHeadType();
		final Number openAngle = this.getHeadOpenAngle();
		final Number closeAngle = this.getHeadCloseAngle();


		// check values
		Number open = ( openAngle!=null ) ? new Float( openAngle.floatValue()*rd ) : null;
		Number close = ( closeAngle!=null ) ? new Float( closeAngle.floatValue()*rd ) : null;
		if( l.hasValidAngle( open, close ) == false )
		{
			this.setInputErrorMessage( MSG_ANGLE_ERROR );
			return false;
		}


		// set values

		if( lineWidth!=null )
		{
			l.setLineWidth( lineWidth.floatValue(), pt );
		}
		
		if( lineType!=null )
		{
			l.setLineType( lineType.intValue() );
		}
		
		if( headSize!=null )
		{
			l.setHeadSize( headSize.floatValue(), cm );
		}

		if( color!=null )
		{
			l.setColor( color );
		}
		
		if( startType!=null )
		{
			l.setStartHeadType( startType.intValue() );
		}
		
		if( endType!=null )
		{
			l.setEndHeadType( endType.intValue() );
		}
		
		if( open!=null )
		{
			l.setHeadOpenAngle( open.floatValue() );
		}

		if( close!=null )
		{
			l.setHeadCloseAngle( close.floatValue() );
		}

		return true;
	}


}

