
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import jp.riken.brain.ni.samuraigraph.figure.SGITickLabelConstants;

import org.w3c.dom.Element;


/**
 *
 */
public abstract class SGElementGroupTickLabel extends SGElementGroupString
	implements SGITickLabelConstants
{


	/**
	 * 
	 *
	 */
	public SGElementGroupTickLabel()
	{
		super();
	}


	/**
	 * 
	 * @param angle
	 * @return
	 */
	public boolean setAngle( final String angle )
	{
		final Float a = getTickLabelAngleFromName( angle );
		if( a==null )
		{
			return false;
		}
		return this.setAngle( a.floatValue() );
	}


	/**
	 * 
	 */
	public static Float getTickLabelAngleFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}

		Float angle = null;
		if( name.equals( HORIZONTAL ) )
		{
			angle = new Float( ANGLE_HORIZONTAL );
		}
		else if( name.equals( INCLINED ) )
		{
			angle = new Float( ANGLE_INCLINED );
		}
		
		return angle;
	}



	/**
	 * 
	 */
	public static String getTickLabelAngleName( final double angle )
	{
		String name = null;

		// angle
		if( angle == ANGLE_HORIZONTAL )
		{
			name = HORIZONTAL;
		}
		else if( angle == ANGLE_INCLINED )
		{
			name = INCLINED;
		}
		else
		{
			throw new Error();
		}

		return name;
	}



	/**
	 * 
	 */
	public boolean writeProperty( final Element el )
	{
		if( super.writeProperty(el) == false )
		{
			return false;
		}

		String strAngle = getTickLabelAngleName( this.mAngle );
		el.setAttribute( KEY_ANGLE, strAngle );

		return true;
	}

	
	
	/**
	 * 
	 * @param el
	 * @return
	 */
	public boolean readProperty( final Element el )
	{
		String str = null;
		Number num = null;
//		Color cl = null;
//		Boolean b = null;
//		ArrayList list = null;

		if( super.readProperty(el) == false )
		{
			return false;
		}


		// angle
		str = el.getAttribute( KEY_ANGLE );
		if( str.length()!=0 )
		{
			num = getTickLabelAngleFromName(str);
			if( num == null )
			{
				return false;
			}
			if( this.setAngle( num.floatValue() ) == false )
			{
				return false;
			}
		}
		
		return true;
	}

	
}

