
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

/**
 * @author  okumura
 */
public class SGElementGroupTimingLine extends SGElementGroupLine
{
	

	/**
	 * 
	 */
	protected SGAxis mAxis = null;


	/**
	 * 
	 */
	protected double mValue;


	/**
	 * 
	 */
	protected SGAxis mParallelAxis = null;


	/**
	 * 
	 */
	protected double mStartValue;

	
	/**
	 * 
	 */
	protected double mEndValue;
	
	
	/**
	 * 
	 */
	public SGElementGroupTimingLine()
	{
		super();
	}


	
	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		TimingLineProperties p = new TimingLineProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof TimingLineProperties ) == false ) return false;

		if( super.getProperties(p) == false )
		{
			return false;
		}

		TimingLineProperties lp = (TimingLineProperties)p;
		lp.setValue( this.mValue );
		lp.axis = this.mAxis;

		return true;
	}

	
	
	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof TimingLineProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		TimingLineProperties tp = (TimingLineProperties)p;
		Double d = tp.getValue();
		if( d==null )
		{
			return false;
		}
		this.setValue( d.doubleValue() );

		SGAxis axis = tp.axis;
		if( axis==null )
		{
			return false;
		}
		this.setAxis( axis );
		
		
		return true;
	}


	
	/**
	 * @author  okumura
	 */
	public static class TimingLineProperties extends SGElementGroupLine.LineProperties
	{

//		public static final String[] keys = { KEY_VALUE };

		private double mValue;
		private SGAxis axis;

		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof TimingLineProperties ) == false ) return false;
			if( super.equals(obj) == false ) return false;

			TimingLineProperties p = (TimingLineProperties)obj;
			if( p.mValue!=this.mValue ) return false;
			if( p.axis != this.axis ) return false;

			return true;
		}

		
		public void setValue( final double value )
		{
			this.mValue = value;
		}

		/**
		 * @param axis  ݒ肷 axisB
		 * @uml.property  name="axis"
		 */
		public void setAxis( final SGAxis Axis )
		{
			if( Axis==null )
			{
				throw new IllegalArgumentException("axis==null");
			}
			this.axis = Axis;
		}
		
		public Double getValue()
		{
			return new Double( this.mValue );
		}

		/**
		 * @return  axis ߂܂B
		 * @uml.property  name="axis"
		 */
		public SGAxis getAxis()
		{
			return this.axis;
		}
	}


	/**
	 * @return mAxis
	 */
	public SGAxis getAxis()
	{
		return this.mAxis;
	}


	/**
	 * 
	 * @return
	 */
	public SGAxis getParallelAxis()
	{
		return this.mParallelAxis;
	}

	
	/**
	 * @param axis mAxis ݒ肵܂B
	 */
	public void setAxis( final SGAxis axis )
	{
		this.mAxis = axis;
	}


	/**
	 * 
	 * @param axis
	 */
	public void setParallelAxis( SGAxis axis )
	{
		this.mParallelAxis = axis;
	}


	
	/**
	 * @return mValue
	 */
	public double getValue()
	{
		return this.mValue;
	}


	/**
	 * 
	 * @return
	 */
	public double getStartValue()
	{
		return this.mStartValue;
	}


	/**
	 * 
	 * @return
	 */
	public double getEndValue()
	{
		return this.mEndValue;
	}

	
	/**
	 * @param value
	 */
	public void setValue( final double value )
	{
		this.mValue = value;
	}


	/**
	 * @param value
	 */
	public void setStartValue( final double value )
	{
		this.mStartValue = value;
	}


	/**
	 * @param value
	 */
	public void setEndValue( final double value )
	{
		this.mEndValue = value;
	}

}

