<?
/**
 * Action_Samurai_Info
 * 
 * Samurai情報を表示するためのAction。
 * dBug必須。
 * 
 * @package    Samurai
 * @subpackage Action.Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Samurai_Info extends Samurai_Action
{
    private
        $_info = array();
    
    
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //情報の設定
        $this->_setInfo();
        //cli
        if($this->Device->isCli()){
            $this->_output4Cli();
        }
        //web
        else {
            if(Samurai_Config::get('enable.samuraiinfo')){
                $this->_output4Web();
            }
        }
        exit;
    }
    
    
    /**
     * 情報の設定。
     * @access     private
     */
    private function _setInfo()
    {
        //SamuraiFW
        $this->_info['SamuraiFW'] = array(
            'version'=>Samurai::VERSION,
            'samurai_dirs' => Samurai::getSamuraiDirs(),
        );
        //Config
        $this->_info['Samurai_Config'] = Samurai_Config::getAll();
    }
    
    
    /**
     * cli用出力。
     * @access     private
     */
    private function _output4Cli()
    {
        //情報出力
        foreach($this->_info as $heading => $info){
            $this->_show($info, $heading);
        }
    }
    
    
    /**
     * web用出力。
     * @access     private
     */
    private function _output4Web()
    {
        Samurai_Loader::load(Samurai_Config::get('directory.library').'/dBug/dBug.php');
        //ヘッダー出力
        $this->_printHeader();
        //情報出力
        foreach($this->_info as $heading => $info){
            $this->_show($info, $heading);
        }
        //フッター出力
        $this->_printFooter();
    }
    
    
    /**
     * ヘッダーを出力する。
     * @access     private
     */
    private function _printHeader()
    {
        echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">';
        echo '<HTML lang="ja-JP">';
        echo '<HEAD>';
        echo '<META http-equiv="Content-Type" content="text/html; charset=UTF-8" />';
        echo '<LINK rel="stylesheet" type="text/css" href="/samurai/samurai.css">';
        echo '<TITLE>Samurai Info - [Samurai Framework]</TITLE>';
        echo '</HEAD>';
        echo '<BODY>';
    }
    
    
    /**
     * フッターを出力する。
     * @access     private
     */
    private function _printFooter()
    {
        echo '</BODY>';
        echo '</HTML>';
    }
    
    
    /**
     * 出力。
     * @access     private
     * @param      mixed   $contents   内容
     * @param      string  $heading    見出し
     * @param      int     $depth      深度
     */
    private function _show($contents, $heading=NULL, $depth=0)
    {
        //cli
        if($this->Device->isCli()){
            for($i = 0; $i <= $depth; $i++) echo " ";
            if($heading !== NULL){
                echo "{$heading} : ";
            }
            if(is_array($contents) || is_object($contents)){
                echo "\n";
                foreach($contents as $_key => $_val){
                    $this->_show($_val, $_key, $depth + 3);
                }
            } else {
                echo $contents;
            }
            echo "\n";
        }
        //web
        else {
            if($heading !== NULL){
                echo "<H1>{$heading}</H1>";
            }
            $dBug = new dBug($contents);
        }
    }
}
