<?
/**
 * Etc_Device_Factory
 * 
 * デバイスインスタンスを取得するためのクラス。
 * 
 * @package    Etc
 * @subpackage Device
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass('Etc_Device_Base');
class Etc_Device_Factory
{
    /**
     * コンストラクタ。
     * @access    private
     */
    private function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * 指定されたデバイスインスタンスを返却する。
     * @access     public
     * @param      string  $user_agent   ユーザーエージェント
     * @return     object  Etc_Device
     */
    public static function getDevice($user_agent="")
    {
        //基本デバイス
        $Device = new Etc_Device_Base($user_agent);
        //独自デバイス
        try {
            $class = 'Etc_Device_'.ucfirst($Device->client);
            Samurai_Loader::loadByClass($class);
            $Device = new $class($user_agent);
        } catch(Samurai_Exception $E){
            Samurai_Logger::fatal('Device not found... -> %s', $Device->client);
        }
        return $Device;
    }
}
