<?
/**
 * Etc_Device_Pc
 * 
 * PC用のデバイスクラス。
 * 
 * @package    Etc
 * @subpackage Device
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Etc_Device_Pc extends Etc_Device_Base
{
    /**
     * コンストラクタ。
     * @access    public
     * @param     string  $user_agent   user_agent
    **/
    public function __construct($user_agent)
    {
        parent::__construct($user_agent);
        $this->browser_name = $this->_agent2name($this->user_agent);
        if(isset($_SERVER['REMOTE_ADDR'])){
            $this->serial = sprintf('%s:%s', $_SERVER['REMOTE_ADDR'], md5($_SERVER['REMOTE_ADDR'].$this->user_agent));
        }
    }
    
    
    /**
     * user_agentを識別名に変換する。
     * IE6,IE7,NetScape,Firefox,Opera,Sleipnir等々。
     * @param      string  $user_agent   user_agent
     * @return     string  識別名
     */
    public function _agent2name($user_agent)
    {
        $name = 'ie6';
        switch(true){
            case preg_match('/sleipnir/i', $user_agent):
                $name = 'sleipnir';
                break;
        }
        return $name;
    }
}
