<?
/**
 * Etc_File_Scanner
 * 
 * ファイルの走査をするクラス。
 * 
 * @package    Samurai
 * @subpackage Etc.File.Scanner
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Samurai_Iterator');
Samurai_Loader::loadByClass('Etc_File_Scanner_Entity');
Samurai_Loader::loadByClass('Etc_File_Scanner_Condition');
class Etc_File_Scanner
{
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 走査トリガー。
     * @access     public
     * @param      string  $directory   ディレクトリパス
     * @return     object  Etc_File_Scanner_Entity
     */
    public function scan($directory, $condition=NULL, $tmp=NULL)
    {
        $Iterator = new Samurai_Iterator();
        $Entity = new Etc_File_Scanner_Entity($directory);
        if($Entity->isDirectory()){
            //昔との互換性を一応保っておく
            if($tmp !== NULL){
                $tmp->reflexive = $condition;
                $condition = $tmp;
            }
            $this->_scan($Iterator, $Entity, $condition);
        } else {
            throw new Samurai_Exception('No directory. -> '.$directory);
        }
        return $Iterator;
    }
    
    
    /**
     * 最もスタンダードな走査。
     * @access     private
     * @param      object  $Iterator    Samurai_Iterator
     * @param      object  $Entity      Etc_File_Scanner_Entity
     * @return     object  $condition   Etc_File_Scanner_Condition
     */
    private function _scan($Iterator, $DirEntity, $condition=NULL)
    {
        $files = scandir($DirEntity->path);
        foreach($files as $file){
            if($file != '.' && $file != '..'){
                $File = new Etc_File_Scanner_Entity($DirEntity->path . DS . $file);
                if(is_bool($condition)){
                    $reflexive = $condition;
                    $condition = Etc_File_Scanner_Condition();
                    $condition->reflexive = $reflexive;
                }
                if($this->_match($File, $condition)){
                    $Iterator->addElement($File);
                    
                }
                if($condition->reflexive && $File->isDirectory()){
                    $this->_scan($Iterator, $File, $condition);
                }
            }
        }
    }
    
    
    /**
     * 条件との比較。
     * @access     private
     * @param      object  $File
     * @param      object  $condition
     * @return     boolean 条件と一致するかどうか
     */
    private function _match($File, $condition=NULL)
    {
        if(!$condition){
            return true;
        } else {
            return $condition->match($File);
        }
    }
    
    
    
    /**
     * 条件を取得する
     * @return     object  Etc_File_Scanner_Condition
     */
    public function getCondition()
    {
        return new Etc_File_Scanner_Condition();
    }
}
