<?
/**
 * Etc_File_Image_Converter_Worker_Gd
 * 
 * 画像のコンバートをサポートするコンポーネント
 * そのGDを使用して処理するWorker
 * 
 * @package    Samurai
 * @subpackage Etc.File.Image.Converter
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_File_Image_Converter_Worker_Gd extends Etc_File_Image_Converter_Worker
{
    /**
     * コンバート実処理
     * @implements
     */
    protected function _convert()
    {
        $new_path = $this->Converter->dirname.'/'.$this->Converter->basename;
        $old_path = $this->Converter->original('dirname').'/'.$this->Converter->original('basename');
        
        //変換
        $image = imagecreatefromstring(file_get_contents($old_path));
        if($this->Converter->diff('width') || $this->Converter->diff('height')){
            $image = $this->_resize($image);
        }
        
        //保存
        switch($this->Converter->type){
            case IMAGETYPE_GIF:
                imagegif($image, $new_path);
                break;
            case IMAGETYPE_JPEG:
                imagejpeg($image, $new_path, 100);
                break;
            case IMAGETYPE_PNG:
                imagepng($image, $new_path);
                break;
            case IMAGETYPE_WBMP:
                imagewbmp($image, $new_path);
                break;
            default:
                throw new Samurai_Exception('unsuported convert format. -> '.$this->Converter->type);
                break;
        }
        return $new_path;
    }
    
    
    /**
     * 画像のリサイズを行う
     * @access     private
     */
    private function _resize($image)
    {
        if($this->Converter->type == IMAGETYPE_GIF){
            $new_image = imagecreate($this->Converter->width, $this->Converter->height);
        } else {
            $new_image = imagecreatetruecolor($this->Converter->width, $this->Converter->height);
        }
        
        //GIF,PNGへの透過色対応
        if($this->Converter->original('type') == IMAGETYPE_GIF || $this->Converter->original('type') == IMAGETYPE_PNG){
            $transparent = imagecolortransparent($image);
            //透過色が設定されている
            if($transparent >= 0){
                imagetruecolortopalette($new_image, true, 256);
                $trans_color = @imagecolorsforindex($image, $transparent);
                if($trans_color){
                    $transparent = imagecolorallocate($new_image, $trans_color['red'], $trans_color['green'], $trans_color['blue']);
                    imagefill($new_image, 0, 0, $transparent);
                    imagecolortransparent($new_image, $transparent);
                }
            //PNG-24
            } elseif($this->Converter->original('type') == IMAGETYPE_PNG){
                imagealphablending($new_image, false);
                imagesavealpha($new_image, true);
                $color = imagecolorallocatealpha($new_image, 0, 0, 0, 127);
                imagefill($new_image, 0, 0, $color);
            }
        }
        imagecopyresampled($new_image, $image, 0, 0, 0, 0,
                                $this->Converter->width, $this->Converter->height,
                                $this->Converter->original('width'), $this->Converter->original('height'));
        return $new_image;
    }
}
