<?
/**
 * Etc_File_Scanner_Entity
 * 
 * ファイルの走査の実体クラス。
 * ファイルやディレクトリを体現する。
 * 
 * @package    Samurai
 * @subpackage Etc.File.Scanner
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_File_Scanner_Entity
{
    public
        /** @var        string  ファイルパス */
        $path,
        /** @var        string  格納ディレクトリ */
        $dirname,
        /** @var        string  ファイル名 */
        $basename,
        /** @var        string  ファイル名(拡張子なし) */
        $filename,
        /** @var        string  拡張子 */
        $extension,
        /** @var        int     パーミッション */
        $permission,
        /** @var        array   正規表現で格納される値 */
        $matches;
    
    
    /**
     * コンストラクタ。
     * @access     public
     * @param      string  $path   ファイルパス
     */
    public function __construct($path)
    {
        $this->init($path);
    }
    
    
    /**
     * 初期化
     * @access     public
     * @param      string  $path   ファイルパス
     */
    public function init($path)
    {
        $info = pathinfo($path);
        $this->path = $path;
        $this->dirname = $info['dirname'];
        $this->basename = $info['basename'];
        $this->filename = isset($info['filename']) ? $info['filename'] : '' ;
        $this->extension = isset($info['extension']) ? $info['extension'] : '' ;
        $this->matches = array();
        if($this->isExists()){
            $this->permission = fileperms($this->path);
        }
    }
    
    
    
    
    
    /**
     * ファイルの中身を取得。
     * @access     public
     * @return     string  ファイルの中身
     */
    public function getContents()
    {
        if(!$this->isExists()) throw new Samurai_Exception('No such file or directory. -> ' . $this->path);
        if($this->isDirectory()) throw new Samurai_Exception('No file. -> ' . $this->path);
        return file_get_contents($this->path);
    }
    
    
    
    
    
    /**
     * コピー。
     * @access     public
     * @param      string  $dest    コピー先
     * @param      boolean $force   無理矢理上書きするか
     */
    public function copy($dest, $force=false)
    {
        if(!$this->isExists()) throw new Samurai_Exception('No such file or directory. -> ' . $this->path);
        if(file_exists($dest) && !$force) throw new Samurai_Exception('Already exists. -> ' . $dest);
        if($this->isDirectory()){
            @mkdir($dest, $this->permission);
            chmod($dest, $this->permission);
        } else {
            copy($this->path, $dest);
            chmod($dest, $this->permission);
        }
    }
    
    
    
    
    
    /**
     * 存在するかどうかを確認。
     * @access     public
     * @return     boolean 存在するかどうか
     */
    public function isExists()
    {
        return file_exists($this->path);
    }
    
    
    /**
     * この実体がディレクトリなのかどうかチェックする。
     * @access     public
     * @return     boolean ディレクトリかどうか
     */
    public function isDirectory()
    {
        return is_dir($this->path);
    }
}
