<?
/**
 * Etc_Helper_Pager_Activegateway
 * 
 * ActiveGatewayでのページング処理をサポートするクラス。
 * 
 * @package    Etc
 * @subpackage Helper.Pager
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Helper_Pager_Activegateway extends Etc_Helper_Pager_Unit
{
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * Pagerの初期化。
     * @access     public
     * @param      object  $Records   ActiveGatewayRecords
     * @param      object  $AGdto     ActiveGatewayCondition
     */
    public function init(ActiveGatewayRecords $Records, $AGdto=NULL)
    {
        $this->total_items = $Records->getTotalRows();
        if($AGdto instanceof ActiveGatewayCondition){
            $this->offset = $AGdto->offset;
            $this->per_page = $AGdto->limit;
        }
        $this->prev = $this->hasPrev();
        $this->next = $this->hasNext();
    }
}
