<?
/**
 * Etc_Mail_Transporter_Sendmail
 * 
 * Etc_Mailの送信担当者。
 * mail関数を使用して送信する。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Mail_Transporter_Mail extends Etc_Mail_Transporter
{
    public
        /** @var        string  付加オプション */
        $parameters;
    
    
    /**
     * @implements
     */
    protected function _send()
    {
        $headers = $this->_adjustHeaders();
        $headers = join(Etc_Mail_Mime_Part::LINEEND, $headers);
        mail($this->_recipients, $this->Mail->getSubject(true), $this->_body, $headers, $this->parameters);
    }
    
    
    /**
     * ヘッダーの調節。
     * @access     private
     * @return     array   ヘッダー
     */
    private function _adjustHeaders()
    {
        $headers = array();
        foreach($this->_headers as $key => $value){
            switch($key){
                case 'to':
                case 'subject':
                    break;
                default:
                    $key = join('-', array_map('ucfirst', explode('-', $key)));
                    $headers[] = "{$key}: {$value}";
                    break;
            }
        }
        return $headers;
    }
}
