<?
/**
 * Etc_Mail_Transporter_Sendmail
 * 
 * Etc_Mailの送信担当者。
 * sendmailを使用して送信する。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Mail_Transporter_Sendmail extends Etc_Mail_Transporter
{
    public
        /** @var        string  sendmailパス */
        $sendmail_path = '/usr/sbin/sendmail',
        /** @var        string  sendmailオプション */
        $sendmail_args = '';
    
    
    /**
     * @implements
     */
    protected function _send()
    {
        //準備
        $headers = $this->_adjustHeaders();
        $headers = join($this->Mail->lineend, $headers);
        $from   = escapeshellcmd($this->Mail->getFrom()->mail);
        $recipients = array();
        foreach($this->Mail->getRecipients() as $Recipient){
            $recipients[] = $Recipient->mail;
        }
        $recipients = escapeshellcmd(join(' ', $recipients));
        $mailtext = $headers.$this->Mail->lineend.$this->Mail->lineend.$this->Part->getContent();
        //Windowsでない場合は、改行コードを\nに統一してあげる必要がある
        if(strpos(PHP_OS, 'WIN') !== 0){
            $mailtext = preg_replace("/\r\n/", "\n", $mailtext);
        }
        
        //送信
        $handle = popen(sprintf('%s%s -f%s -- %s', $this->sendmail_path,
                                    $this->sendmail_args ? ' '.$this->sendmail_args : '', $from, $recipients), 'w');
        if(!$handle){
            throw new Samurai_Exception('Failed to open sendmail. -> '.$this->sendmail_path);
        }
        fputs($handle, $mailtext);
        $result = pclose($handle);
        if ($result != 0) {
            throw new Samurai_Exception('sendmail returned error code. -> '.$result);
        }
    }
    
    
    /**
     * ヘッダーの調節。
     * @access     private
     * @return     array   ヘッダー
     */
    private function _adjustHeaders()
    {
        $headers = array();
        foreach($this->Part->getHeaders() as $key => $value){
            switch($key){
                default:
                    $key = join('-', array_map('ucfirst', explode('-', $key)));
                    $headers[] = sprintf('%s: %s', $key, $value);
                    break;
            }
        }
        return $headers;
    }
}
