<?
/**
 * Etc_Misc_Date
 * 
 * 日付コンポーネント
 * 
 * @package    Samurai
 * @subpackage Etc.Misc
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Misc_Date
{
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 日付文字列から年を取得する
     * @access     public
     * @param      string  $date
     */
    public function getYear($date)
    {
        if(preg_match('/^([\d]{4})-?[\d]{2}(-?[\d]{2})?$/', (string)$date, $matches)){
            return $matches[1];
        } else {
            return date('Y');
        }
    }
    
    
    /**
     * 日付文字列から月を取得する
     * @access     public
     * @param      string  $date
     */
    public function getMonth($date)
    {
        if(preg_match('/^[\d]{4}-?([\d]{2})(-?[\d]{2})?$/', (string)$date, $matches)){
            return $matches[1];
        } else {
            return date('m');
        }
    }
}
