<?
/**
 * Etc_Oop_Array
 * 
 * [[機能説明]]
 * 
 * @package    Samurai
 * @subpackage Etc.Oop
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Oop_Array extends Etc_Oop
{
    /**
     * 実体をセットする。
     * @access     public
     * @param      array  $entity
     */
    public function set($entity)
    {
        $this->_entity = (array)$entity;
    }
    
    
    /**
     * 文字列への変換。
     * @access     private
     * @return     string  文字列の実体
     */
    public function __toString()
    {
        return (string)$this->_entity;
    }
    
    
    
    
    
    /**
     * 配列へのアクセス。
     * @access     public
     * @param      string  $name   キー
     */
    public function __get($name)
    {
        $result = isset($this->_entity[$name]) ? $this->_entity[$name] : NULL ;
        return $this->cast($result);
    }
    /**
     * 配列にセット
     * @access     public
     * @param      string  $name    キー
     * @param      mixed   $value   値
     */
    public function __set($name, $value)
    {
        $this->_entity[$name] = $value;
    }
    
    
    /**
     * PHP関数へのブリッジ。
     * @access     public
     */
    public function __call($method, $args=array())
    {
        if(function_exists($method)){
            array_unshift($args, $this->_entity);
            $result = call_user_func_array($method, $args);
            return $this->cast($result);
        } else {
            throw new Samurai_Exception('method not exists. -> '.$method);
        }
    }
    
    
    
    
    
    /**
     * XMLへの変換。
     * @access     public
     * @return     object  Etc_Oop_String
     */
    public function toXml()
    {
        
    }
    
    
    
    
    
    /**
     * __callでは対応しきれないものや、
     * str_*のように文字列にかける事を明言しているような場合、それを省略できるように。
     * @access     public
     */
    public function length()
    {
        return $this->cast(count($this->_entity));
    }
    public function unshift($value)
    {
        array_unshift($this->_entity, $value);
        return $this;
    }
    public function push($value)
    {
        array_push($this->_entity, $value);
        return $this;
    }
    public function shift()
    {
        return $this->cast(array_shift($this->_entity));
    }
    public function pop()
    {
        return $this->cast(array_pop($this->_entity));
    }
}
