<?
/**
 * Etc_Oop_Integer
 * 
 * [[機能説明]]
 * 
 * @package    Samurai
 * @subpackage Etc.Oop
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Oop_Integer extends Etc_Oop
{
    /**
     * 実体をセットする。
     * @access     public
     * @param      int     $entity
     */
    public function set($entity)
    {
        $this->_entity = is_float($entity) ? (float)$entity : (int)$entity;
    }
    
    
    /**
     * 文字列への変換。
     * @access     private
     * @return     string  文字列の実体
     */
    public function __toString()
    {
        return $this->_entity;
    }
    
    
    
    
    
    /**
     * PHP関数へのブリッジ。
     * @access     public
     */
    public function __call($method, $args=array())
    {
        if(function_exists($method)){
            array_unshift($args, $this->_entity);
            $result = call_user_func_array($method, $args);
            return $this->cast($result);
        } else {
            throw new Samurai_Exception('method not exists. -> '.$method);
        }
    }
    
    
    /**
     * __callでは対応しきれないものや、
     * str_*のように文字列にかける事を明言しているような場合、それを省略できるように。
     * @access     public
     */
}
