<?
/**
 * Filter_ActiveGateway
 * 
 * SamuraiFWとActiveGatewayの橋渡しを行うフィルター。
 * 設定ファイルの読み込み、およびAGの生成。
 * およびDIContainerへの登録をおこなう。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_ActiveGateway extends Samurai_Filter
{
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //ロード
        Samurai_Loader::load(Samurai_Config::get('directory.library').'/ActiveGateway/ActiveGatewayManager.class.php');
        //設定ファイルの読み込み
        $this->_importConfig('activegateway.yml');
        foreach($this->getAttributes() as $conf_file){
            $this->_importConfig($conf_file);
        }
    }
    
    
    /**
     * 設定ファイルの読み込み。
     * @access     private
     */
    private function _importConfig($conf_file)
    {
        $conf_file = sprintf('%s/activegateway/%s', Samurai_Config::get('directory.config'), $conf_file);
        ActiveGatewayManager::singleton()->import($conf_file);
    }
}
