<?
/**
 * Filter_Auth
 * 
 * 認証のためのフィルター。
 * 各種認証を取りそろえております。
 * ROLE | LEVEL | HTTP | IP
 * 等々、揃えられております。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Auth extends Samurai_Filter
{
    public
        /** @var        object  AuthManagerコンポーネント */
        $Manager,
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //初期化
        $this->_init();
        //Authorの決定
        $Author = $this->Manager->getAuthor($this->getAttribute('type'));
        //認証
        $result = $Author->authorize($this->getAttributes());
        if($result !== true){
            if(is_array($result)){
                $message = array_pop($result);
                $result  = array_shift($result);
            } else {
                $message = '';
            }
            $ErrorList = $this->ActionChain->getCurrentErrorList();
            $ErrorList->setType($result);
            if($message && !$ErrorList->isExists()) $ErrorList->add('authorize', $message);
        }
    }
    
    
    
    
    
    /**
     * 初期化。
     * @access     private
     */
    private function _init()
    {
        //Managerの生成
        Samurai_Loader::loadByClass('Filter_Auth_Manager');
        $this->Manager = new Filter_Auth_Manager();
    }
}
