<?
/**
 * Filter_Session
 * 
 * セッション使用準備をおこなうFilter。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Session extends Samurai_Filter
{
    public
        /** @var        object  Sessionコンポーネント */
        $Session;
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //Sessionコンポーネント補完
        if(!$this->Session){
            $Container = Samurai::getContainer();
            $Def = $Container->getContainerDef();
            $Def->class = 'Samurai_Request_Session';
            $Container->registerComponent('Session', $Def);
            $this->Session = $Container->getComponent('Session');
        }
        //情報の設定
        foreach($this->getAttributes() as $_key => $_val){
            switch($_key){
                case 'type':
                    $this->Session->setType((string)$_val);
                    break;
                case 'dsn':
                    $this->Session->setDsn((string)$_val);
                    break;
                case 'name':
                    $this->Session->name((string)$_val);
                    break;
                case 'id':
                    $this->Session->id((string)$_val);
                    break;
                case 'save_path':
                    $this->Session->savePath((string)$_val);
                    break;
                case 'cache_limiter':
                    $this->Session->cacheLimiter((string)$_val);
                    break;
                case 'cache_expire':
                    $this->Session->cacheExpire((int)$_val);
                    break;
                case 'use_cookies':
                    $this->Session->setUseCookies((int)$_val);
                    break;
                case 'cookie_lifetime':
                    $this->Session->setCookieLifetime((int)$_val);
                    break;
                case 'cookie_path':
                    $this->Session->setCookiePath((string)$_val);
                    break;
                case 'cookie_domain':
                    $this->Session->setCookieDomain((string)$_val);
                    break;
                case 'cookie_sequre':
                    $this->Session->setCookieSequre((bool)$_val);
                    break;
                case 'gc_divisor':
                case 'gc_probability':
                case 'gc_maxlifetime':
                    $this->Session->setGCConfig($_key, (int)$_val);
                    break;
            }
        }
        //Session開始
        $this->Session->start();
    }
    
    
    /**
     * postfilter.
     * @override
     */
    protected function _postfilter(){
        parent::_postfilter();
        
        $attributes = $this->getAttributes();
        if(isset($attributes['close'])){
            $this->Session->close($attributes['close']);
        }
    }
}
