<?
/**
 * Filter_Auth_Author_Basic
 * 
 * BASIC認証による認証をかけるFilter。
 * 
 * @package    Samurai
 * @subpackage Filter.Auth
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Auth_Author_Basic extends Filter_Auth_Author
{
    public
        /** @var        object  Samurai_Response_Http */
        $Response;
    
    
    /**
     * authorize.
     * @implements
     */
    public function authorize(array $params)
    {
        //初期化
        $name  = 'AUTH_HTTP';
        $title = 'Please, Enter the ID & Password.';
        $users = array();
        $error_message = '認証に失敗しました。';
        foreach($params as $_key => $_val){
            switch($_key){
                case 'name':
                case 'title':
                case 'error_message':
                    $$_key = (string)$_val; break;
                case 'users':
                    $$_key = (array)$_val; break;
            }
        }
        
        //認証
        if(!isset($_SERVER['PHP_AUTH_USER'])){
            return $this->_basicAuthorize($title, $error_message);
        } else {
            foreach($users as $name => $pass){
                if($name == $_SERVER['PHP_AUTH_USER']){
                    if($this->_authorize($pass, $_SERVER['PHP_AUTH_PW'])){
                        return true;
                    }
                }
            }
        }
        return $this->_basicAuthorize($title, $error_message);
    }
    
    
    /**
     * 実際にBASIC認証を表示する。
     * @access     private
     * @since      1.0.0
     * @param      string  $title           タイトル文
     * @param      string  $error_message   エラー文字列
     * @return     string  エラー文字列
     */
    private function _basicAuthorize($title, $error_message){
        $this->Response->setStatus(401);
        $this->Response->setHeader('WWW-Authenticate', "Basic realm='{$title}'");
        return array(Samurai_Config::get('error.auth'), $error_message);
    }
    
    
    /**
     * パスワードと入力されたパスワードが一致するかチェック。
     * @access     private
     * @param      string  $pass    パスワード
     * @param      string  $input   入力されたパスワード
     * @param      boolean 結果
     */
    private function _authorize($pass, $input)
    {
        $hash = 'raw';
        if(strpos($pass, ':')){
            list($hash, $pass) = explode(':', $pass);
        }
        switch($hash){
            case 'md5':
                $input = md5($input);
                break;
            case 'sha1':
                $input = sha1($input);
                break;
        }
        return $pass == $input;
    }
}
