<?
/**
 * Filter_Auth_Author_Logout
 * 
 * ログアウトするフィルター
 * 
 * @package    Samurai
 * @subpackage Filter.Auth
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Auth_Author_Logout extends Filter_Auth_Author
{
    public
        /** @var        object  Sessionコンポーネント */
        $Session,
        /** @var        object  Cookieコンポーネント */
        $Cookie;
    
    
    /**
     * authorize
     * @implements
     */
    public function authorize(array $params)
    {
        //初期化
        $name = 'AUTH_DB';
        foreach($params as $_key => $_val){
            switch($_key){
                case 'name':
                    $$_key = trim((string)$_val); break;
            }
        }
        //情報のクリア
        $this->_clearInfoFromCookie($name);
        $this->_clearInfoFromSession($name);
        return true;
    }
    
    
    /**
     * セッションの値を削除する。
     * @access     protected
     * @param      string  $namespace   認証名前空間
     */
    protected function _clearInfoFromSession($namespace)
    {
        $this->Session->delParameter('SAMURAI_FILTER_AUTH.'.$namespace);
    }
    
    
    /**
     * クッキーの情報を消去する。
     * @access     protected
     * @param      string  $namespace   認証名前空間
     */
    protected function _clearInfoFromCookie($namespace)
    {
        $this->Cookie->delParameter('SAMURAI_FILTER_AUTH.'.$namespace);
    }
}
