<?
/**
 * Filter_Convert_Converter.abstract
 * 
 * Converterの抽象クラス。
 * 
 * @package    Samurai
 * @subpackage Filter.Convert
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Filter_Convert_Converter
{
    /**
     * コンバート処理。
     * @access     public
     * @param      mixed   $value   値
     * @return     mixed   コンバートされた値
     */
    public function convert($value)
    {
        if(is_array($value)){
            foreach($value as $_key => $_val){
                $value[$_key] = $this->convert($_val);
            }
        } else {
            $value = $this->_convert($value);
        }
        return $value;
    }
    
    
    /**
     * コンバート実処理。
     * @access     protected
     * @param      mixed   $value   値
     * @return     mixed   コンバートされた値
     */
    protected function _convert($value)
    {
        return $value;
    }
}
