<?
/**
 * Filter_Debug_Debugger_DeviceChanger
 * 
 * Filter_Debugで使用されるDeviceChangerデバッガ。
 * Filter_Front_DeviceChangerを簡単に利用できるようになる
 * 
 * @package    Filter
 * @subpackage Debug
 * @see        Etc_Device
 * @see        Filter_Debug_Debugger_DeviceChanger
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Debug_Debugger_DeviceChanger extends Filter_Debug_Debugger
{
    public
        $position = 'menu',
        $icon = 'DeviceChanger',
        $heading = 'DeviceChanger';
    public
        $Device,
        $Request,
        $FileScanner;
    private
        $_dirs = array(),
        $_devices = array();
    protected
        $_escape = false;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        //FileScannerのセット
        $this->_setFileScanner();
        //デバイス一覧の取得
        foreach(Samurai::getSamuraiDirs() as $dir){
            //component/filter/front/.device
            $dir = sprintf('%s/%s/front/.device', $dir, Samurai_Config::get('directory.filter'));
            try {
                $condition = $this->FileScanner->getCondition();
                $condition->setRegexp('|/\.svn|');
                $condition->negative = true;
                $condition->target = 'path';
                $condition->reflexive = true;
                $files = $this->FileScanner->scan($dir, $condition);
                foreach($files as $file){
                    if($file->isDirectory()){
                        $this->_dirs[] = $file;
                    } else {
                        $this->_devices[] = $file;
                    }
                }
            } catch(Samurai_Exception $E){}
        }
        //それを展開する
        $this->_content = array();
        $this->_content[] = '<A href="?samurai_device_changer=reset">元に戻す</A>';
        foreach($this->_dirs as $dir){
            $this->_content[$dir->basename] = array();
        }
        foreach($this->_devices as $file){
            $dirname = basename($file->dirname);
            $this->_content[$dirname][] = sprintf('<A href="?samurai_device_changer=%s/%s">%s</A>',
                                                        $dirname, $file->basename, $file->basename);
        }
    }
    
    
    
    
    
    /**
     * fileScannerのセット
     * @access     private
     */
    private function _setFileScanner()
    {
        if(!$this->FileScanner){
            $Container = Samurai::getContainer();
            $Def = $Container->getContainerDef();
            $Def->class = 'Etc_File_Scanner';
            $this->FileScanner = $Container->getComponentByDef('FileScanner', $Def);
        }
    }
}
