<?
/**
 * Filter_Debug_Debugger_Renderer
 * 
 * Filter_Debugで使用されるRendererデバッガ。
 * Rendererコンポーネントの内容をデバッグウインドウに反映する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @see        Samurai_Renderer
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Debug_Debugger_Renderer extends Filter_Debug_Debugger
{
    public
        $position = 'menu',
        $icon = 'Renderer',
        $heading = 'Renderer';
    public
        $Renderer;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        Samurai_Loader::load(Samurai_Config::get('directory.library').'/dBug/DumpHelper.class.php');
        $DumpHelper = new dBug_DumpHelper();
        $this->_content = $DumpHelper->removeCircularReference($this->Renderer->getAssignedVars());
    }
}
