<?
/**
 * Filter_Front_Mobile
 * 
 * 携帯端末への対応フロントフィルター。
 * Filter_Front_Deviceフィルターの後に配置してください。
 * 
 * @package    Samurai
 * @subpackage Filter.Front
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 * @see        Filter_Front_Device
 */
class Filter_Front_Mobile extends Samurai_Filter
{
    public
        /** @var        object  Device */
        $Device,
        /** @var        object  Request */
        $Request;
    
    
    /**
     * prefilter.
     * @override
     */
    public function _prefilter()
    {
        parent::_prefilter();
        if($this->Device->isMobile()){
            Samurai_Config::set('action.prefix', $this->getAttribute('action.prefix', 'action4mobile'));
            Samurai_Config::set('directory.action', $this->getAttribute('directory.action', 'component/action4mobile'));
            Samurai_Config::set('directory.template', $this->getAttribute('directory.template', 'template4mobile'));
            Samurai_Config::set('encoding.input', $this->getAttribute('encoding.input', 'SJIS-WIN'));
            Samurai_Config::set('encoding.output', $this->getAttribute('encoding.output', 'SJIS-WIN'));
            $this->Request->import($this->Request->getParameters());
        }
    }
}
