<?
/**
 * Filter_Token_Ticket
 * 
 * Tokenチケットクラス。
 * 
 * @package    Samurai
 * @subpackage Filter.Token
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Token_Ticket
{
    public
        /** @var        string  トークン名 */
        $name = '',
        /** @var        object  Sessionコンポーネント */
        $Session,
        /** @var        object  Requestコンポーネント */
        $Request;
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * Tokenの名前を返却。
     * @access    public
     * @return    string   Tokenの名前
     */
    public function getName()
    {
        if($this->_name == '') $this->_name = '_token';
        return $this->_name;
    }
    /**
     * Tokenの名前を設定。
     * @access    public
     * @param     string  $name   Tokenの名前
     */
    public function setName($name)
    {
        $this->_name = $name;
    }
    
    
    /**
     * Tokenの値を返却。
     * @access    public
     * @return    string   Tokenの値
     */
    public function getValue()
    {
        return $this->Session->getParameter($this->getName());
    }
    
    
    
    
    
    /**
     * Tokenの値を生成。
     * @access    public
     */
    public function build()
    {
        $this->Session->setParameter($this->getName(), md5(uniqid(rand(),1)));
    }
    
    
    /**
     * Tokenの値を比較。
     * @access    public
     * @return    boolean Tokenの値が一致するかどうか
     */
    public function check()
    {
        if($this->getValue() == ''){
            return false;
        } else {
            return $this->getValue() === $this->Request->getParameter($this->getName());
        }
    }
    
    
    /**
     * Tokenの値を削除。
     * @access    public
     */
    public function remove()
    {
        $this->Session->delParameter($this->getName());
    }
}
