<?
/**
 * Filter_Validate_Manager
 * 
 * Validate処理を管理するクラス。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Filter_Validate_Validator');
class Filter_Validate_Manager
{
    private
        /** @var        array   バリデーターキャッシュ */
        $_validators = array();
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function Filter_Validate_Manager()
    {
        
    }
    
    
    
    
    
    /**
     * validateトリガ。
     * @access     public
     * @param      string  $validator   バリデータ名
     * @param      mixed   $value       値
     * @param      array   $params      付加値
     * @return     boolean 検証に成功したかどうか
     */
    public function validate($validator, $value, $params)
    {
        $Validator = $this->getValidator($validator);
        return $Validator->validate($value, $params);
    }
    
    
    
    
    
    /**
     * Validatorの取得。
     * @access     public
     * @param      string  $name   バリデータ名
     * @return     object  バリデータ
     */
    public function getValidator($name)
    {
        if(!isset($this->_validators[$name])){
            $class = 'Filter_Validate_Validator_'.ucfirst($name);
            if(Samurai_Loader::loadByClass($class)){
                $Validator = new $class();
            } else {
                $class = 'Filter_Validate_Validator_Native';
                Samurai_Loader::loadByClass($class);
                $Validator = new $class($name);
            }
            Samurai::getContainer()->injectDependency($Validator);
            $this->_validators[$name] = $Validator;
        }
        return $this->_validators[$name];
    }
}
