<?
/**
 * Filter_Validate_Validator_Date
 * 
 * 日付の妥当性チェック。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Validate_Validator_Date extends Filter_Validate_Validator
{
    /**
     * 日付の妥当性チェック。
     * @implements
     * @param      array   $value
     */
    public function validate($value, $params=array())
    {
        if(is_array($value)){
            $_value = $value;
            $year = array_shift($_value);
            $month = array_shift($_value);
            $day = array_shift($_value);
        } else {
            @list($year, $month, $day) = preg_split('/[^\d]+/', $value);
        }
        if($value && ($year || $month || $day)){
            return checkdate((int)$month, (int)$day, (int)$year);
        } else {
            return true;
        }
    }
}
