<?
/**
 * Filter_Validate_Validator_Match
 * 
 * 正規表現にマッチするかどうか。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Validate_Validator_Match extends Filter_Validate_Validator
{
    /**
     * 正規表現にマッチするかどうか。
     * @implements
     */
    public function validate($value, $params=array())
    {
        //正規表現内に「,」が含まれていて分断されている可能性があるので、つないでおく
        $regexp = join(',', $params);
        return preg_match($regexp, $value);
    }
}
