<?
/**
 * Filter_Validate_Validator_Maxcount
 * 
 * 配列が指定の数をオーバーしていないかどうか。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Validate_Validator_Maxcount extends Filter_Validate_Validator
{
    private
        $_limit = 0,
        $_length = 0;
    
    /**
     * 指定の文字数をオーバーしていないかどうか。
     * @implements
     */
    public function validate($value, $params=array())
    {
        $this->_limit = (int)array_shift($params);
        $this->_length = count((array)$value);
        return $this->_length <= $this->_limit;
    }
    
    /**
     * エラー文言の補完。
     * @override
     */
    public function bindParams($message)
    {
        $this->_bindParam($message, ':limit', $this->_limit);
        $this->_bindParam($message, ':length', $this->_length);
        return $message;
    }
}
