<?
/**
 * Filter_Validate_Validator_Minlength
 * 
 * 指定文字数以上かどうか。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Validate_Validator_Minlength extends Filter_Validate_Validator
{
    /**
     * 指定文字数以上かどうか。
     * @implements
     */
    public function validate($value, $params=array())
    {
        $this->_limit = (int)array_shift($params);
        $this->_length = strlen($value);
        return $this->_length >= $this->_limit;
    }
    
    
    /**
     * エラー文言の補完。
     * @override
     */
    public function bindParams($message)
    {
        $charlen = strlen('侍');
        $this->_bindParam($message, ':limit_full', floor($this->_limit / $charlen));
        $this->_bindParam($message, ':length_full', floor($this->_length / $charlen));
        $this->_bindParam($message, ':limit', $this->_limit);
        $this->_bindParam($message, ':length', $this->_length);
        return $message;
    }
}
