<?
/**
 * Filter_Validate_Validator_Native
 * 
 * nativeなPHP関数へブリッジする。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Validate_Validator_Native extends Filter_Validate_Validator
{
    private
        $_function = '';
    
    
    /**
     * コンストラクタ。
     * @access     public
     * @param      string  $function   関数名
     */
    public function __construct($function)
    {
        if(function_exists($function)){
            $this->_function = $function;
        } else {
            throw new Samurai_Exception('Not found such validator. -> '.$function);
        }
    }
    
    
    /**
     * nativeなPHP関数にブリッジ。
     * @access     public
     */
    public function validate($value, $params=array())
    {
        array_unshift($params, $value);
        return call_user_func_array($this->_function, $params);
    }
}
