<?
/**
 * Filter_Validate_Validator_Past
 * 
 * 過去の日付ではないかどうか
 * 
 * <code>
 *     date1.past : '過去の日付は指定できません,false'
 *     date2,date1.past : 'date2は、date1より過去の日付を指定することができません'
 * </code>
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Validate_Validator_Past extends Filter_Validate_Validator
{
    public
        /** @var        object  Utilityコンポーネント */
        $Utility;
    
    
    /**
     * 過去の日付でないかどうか
     * @implements
     * @param      mixed   $value   日付を表す文字列か、比較対象の日付をまとめた配列
     */
    public function validate($value, $params=array())
    {
        //準備
        $today_cover = array_shift($params);
        $today_cover = $this->Utility->str2Bool($today_cover === NULL ? 'true' : $today_cover);
        if(is_array($value)){
            $date1 = strtotime((string)array_shift($value));
            $date2 = strtotime((string)array_shift($value));
        } else {
            $date1 = strtotime($value);
            $date2 = strtotime(date('Y-m-d'));
        }
        //比較
        if($date1 > $date2){
            return true;
        } elseif($date1 == $date2 && $today_cover){
            return true;
        }
        return false;
    }
}
