<?
/**
 * Samurai_Iterator
 * 
 * Samurai用走査クラスの実装。
 * 
 * @package    Samurai
 * @subpackage Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Samurai_Iterator implements Iterator
{
    protected
        $_elements = array(),
        $_index = 0;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 要素の追加。
     * @access     public
     * @param      mixed   $element   要素
     * @param      mixed   $key       キー
     */
    public function addElement($element, $key=NULL)
    {
        if($key === NULL){
            $this->_elements[] = $element;
        } else {
            $this->_elements[$key] = $element;
        }
    }
    
    
    /**
     * 空にする。
     * @access     public
     */
    public function clear()
    {
        $this->_elements = array();
    }
    
    
    /**
     * 逆にする
     * @access     public
     */
    public function reverse()
    {
        $this->_elements = array_reverse($this->_elements);
    }
    
    
    /**
     * 要素を削除する
     * @access     public
     * @param      int     $key
     */
    public function remove($_key)
    {
        if(isset($this->_elements[$_key])){
            unset($this->_elements[$_key]);
        }
    }
    
    
    /**
     * 要素数を取得
     * @access     public
     * @return     int     要素数
     */
    public function getSize()
    {
        return count($this->_elements);
    }
    
    
    
    
    
    /**
     * implements.
     */
    public function rewind()
    {
        $this->_index = 0;
    }
    public function key()
    {
        return $this->_index;
    }
    public function current()
    {
        return isset($this->_elements[$this->_index]) ? $this->_elements[$this->_index] : false;
    }
    public function next()
    {
        $this->_index++;
    }
    public function valid()
    {
        $current = $this->current();
        if($current === false) $this->rewind();
        return $current !== false;
    }
}
