<?
/**
 * Samurai_Migration
 * 
 * マイグレートクラス
 * Railsのぱくりです。
 * 
 * @package    Samurai
 * @subpackage Migrate
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Samurai_Migration
{
    public
        /** @var        object  ActiveGateway */
        $AG;
    public
        $dsn = 'base',
        $time = 0.0,
        $message = '';
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 初期化メソッド
     * 実行前に呼ばれる
     * @access     public
     */
    public function setup()
    {
        $this->AG = ActiveGatewayManager::getActiveGateway($this->dsn);
    }
    
    
    
    
    
    /**
     * 計測メソッド
     * @access     public
     */
    public function start()
    {
        $this->time = microtime(true);
    }
    public function getTime()
    {
        return round(microtime(true) - $this->time, 4);
    }
}
