<?
/**
 * Samurai_Logger_Def
 * 
 * ロガークライアントの抽象クラス。
 * 
 * @package    Samurai
 * @subpackage Samurai.Logger
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
abstract class Samurai_Logger_Client
{
    private
        /** @var        object  ロガークライアント実体の保持 */
        $_instance;
    public
        /** @var        boolean このロガーが有効かどうか */
        $enable = true,
        /** @var        string  ロガークライアント名 */
        $client = "",
        /** @var        array   ロガークライアントを生成する際の引数 */
        $args = array(),
        /** @var        int     ログレベル(default=warn) */
        $log_level = 3;
    public
        /** @const      int     ログレベルFATAL */
        $LOG_LEVEL_FATAL = 5,
        /** @const      int     ログレベルERROR */
        $LOG_LEVEL_ERROR = 4,
        /** @const      int     ログレベルWARN */
        $LOG_LEVEL_WARN  = 3,
        /** @const      int     ログレベルINFO */
        $LOG_LEVEL_INFO  = 2,
        /** @const      int     ログレベルDEBUG */
        $LOG_LEVEL_DEBUG = 1;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct(array $define=array())
    {
        //割り当て
        $this->define($define);
    }
    
    
    /**
     * 宣言内容をセットする。
     * @access     public
     * @param      array   $define   宣言内容
     */
    public function define(array $define)
    {
        foreach($define as $_key => $_val){
            switch($_key){
                case 'enable':
                    $this->$_key = (bool)$_val;
                    break;
                case 'logger':
                    $this->$_key = (string)$_val;
                    break;
                case 'args':
                    $this->$_key = (array)$_val;
                    break;
                case 'log_level':
                    $this->log_level = $this->_logLevelStr2Int($_val);
                    break;
            }
        }
    }
    
    
    
    
    
    /**
     * トリガー。
     * 実際にはこのメソッドが、Samurai_Loggerによって起動される。
     * @access     public
     */
    abstract public function trigger($level, $message, $file, $line);
    
    
    
    
    
    /**
     * このクライアントが現在有効かどうかのチェック。
     * @access     public
     * @return     boolean 有効かどうか
     */
    public function isEnable()
    {
        return $this->enable;
    }
    
    
    /**
     * この渡されたログレベルがクライアントによって有効な値かどうか。
     * また動作すべきかどうか。
     * @access     public
     * @param      string  $log_level   ログレベル(文字列でくる)
     * @return     boolean 有効かどうか
     */
    public function validLevel($log_level)
    {
        $level = $this->_logLevelStr2Int($log_level);
        return $level >= $this->log_level;
    }
    
    
    
    
    
    /**
     * ログレベルの文字列から、定数で定義されている数値に変換する。
     * @access     protected
     * @param      string  $log_level
     * @return     int     定数で定義されている値
     */
    protected function _logLevelStr2Int($log_level)
    {
        $_key = "LOG_LEVEL_".strtoupper($log_level);
        return isset($this->$_key) ? $this->$_key : NULL ;
    }
    /**
     * ログレベルの数値から、定数名の一部を変換する。
     * @access     protected
     * @param      int     $log_level
     * @return     string  定数名の一部
     */
    protected function _logLevelInt2Str($log_level)
    {
        foreach(get_object_vars($this) as $_key => $_val){
            if(preg_match('/^LOG_LEVEL_([\w_]+)/', $_key, $matches)){
                if($_val == $log_level) return strtolower($matches[1]);
            }
        }
        return NULL;
    }
}
