<?
/**
 * Samurai_Renderer_Phptal
 * 
 * SamuraiFWとPhptalとのブリッジクラス。
 * 
 * @package    Samurai
 * @subpackage Samurai.Renderer
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Samurai_Renderer');
Samurai_Loader::loadByClass('Samurai_Renderer_Engine_Phptal');
class Samurai_Renderer_Phptal extends Samurai_Renderer
{
    protected
        /** @var        object  Smartyインスタンス */
        $Engine;
    
    
    /**
     * setEngine.
     * @override
     */
    protected function _setEngine()
    {
        $this->Engine = new Samurai_Renderer_Engine_Phptal();
        Samurai::getContainer()->injectDependency($this->Engine);
    }
    
    
    /**
     * render.
     * @override
     */
    public function render($template)
    {
        $this->Engine->setTemplate($template);
        $result = $this->Engine->execute($template);
        return $result;
    }
    
    
    /**
     * assign.
     * @implements
     */
    public function assign($key, $value)
    {
        $this->Engine->set($key, $value);
    }
    
    
    /**
     * getAssignedVars.
     * @override
     */
    public function getAssignedVars()
    {
        return $this->Engine->get_template_vars();
    }
    
    
    /**
     * Helperの登録。
     * @access     public
     * @param      string  $alias    登録名
     * @param      array   $define   宣言内容
     */
    public function addHelper($alias, $define)
    {
        /*
        $Container = Samurai::getContainer();
        $Container->registerComponent("Renderer_Smarty_{$alias}", new Samurai_Container_Def($define));
        $this->Engine->register_object($alias, $Container->getComponent("Renderer_Smarty_{$alias}"));
        */
    }
    
    
    
    
    
    /**
     * Setters.
     * @implements
     */
    public function setAction($Action)
    {
        $Action->beforeRenderer();
        $this->assign('Action', $Action);
        //$this->Engine->register_object('Action', $Action);
        foreach(get_object_vars($Action) as $_key => $_val){
            if(!preg_match('/^_/', $_key)){
                $this->assign($_key, $_val);
            }
        }
    }
    public function setErrorList($ErrorList)
    {
        $this->assign('ErrorList', $ErrorList);
        //$this->Engine->register_object('ErrorList', $ErrorList);
    }
    public function setRequest($Request)
    {
        $this->assign('Request', $Request);
        $this->assign('request', $Request->getParameters());
        //$this->Engine->register_object('Request', $Request);
    }
    public function setCookie($Cookie)
    {
        $this->assign('Cookie', $Cookie);
        $this->assign('cookie', $Cookie->getParameters());
        //$this->Engine->register_object('Cookie', $Cookie);
    }
    public function setSession($Session)
    {
        $this->assign('Session', $Session);
        $this->assign('session', $Session->getParameters());
        //$this->Engine->register_object('Session', $Session);
    }
    public function setServer($server)
    {
        $this->assign('server', $server);
    }
    public function setScriptName($script_name)
    {
        $this->assign('script_name', $script_name);
    }
    public function setToken($Token)
    {
        $this->assign('Token', $Token);
        $this->assign('token', array('name'=>$Token->getName(), 'value'=>$Token->getValue()));
        //$this->Engine->register_object('Token', $Token);
    }
}
