<?
/**
 * Samurai_Renderer_Simple
 * 
 * テンプレートをピュアPHPで記述できるようにしてくれるレンダラー。
 * 
 * @package    Samurai
 * @subpackage Samurai.Renderer
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Samurai_Renderer');
class Samurai_Renderer_Simple extends Samurai_Renderer
{
    public
        /** @var        string  テンプレートディレクトリ */
        $template_dir = '';
    private
        /** @var        array   アサインされた変数 */
        $_vars = array();
    
    
    /**
     * renderer.
     * @override
     */
    public function render($template)
    {
        if(Samurai_Loader::isAbsolutePath($template)){
            $__template = $template;
        } else {
            $__template = Samurai_Loader::getPath($this->template_dir . DS . $template);
        }
        if(Samurai_Loader::isReadable($__template)){
            ob_start();
            extract($this->_vars);
            include $__template;
            $result = ob_get_contents();
            ob_end_clean();
            return $result;
        } else {
            throw new Samurai_Exception('Template is not found... -> ' . $template);
        }
    }
    
    
    /**
     * assign.
     * @implements
     */
    public function assign($key, $value)
    {
        $this->_vars[$key] = $value;
    }
    
    
    /**
     * getAssignedVars.
     * @override
     */
    public function getAssignedVars()
    {
        return $this->_vars;
    }
    
    
    /**
     * Helperの登録。
     * @access     public
     * @param      string  $alias    登録名
     * @param      array   $define   宣言内容
     */
    public function addHelper($alias, $define)
    {
        $Container = Samurai::getContainer();
        $Container->registerComponent("Renderer_Simple_{$alias}", new Samurai_Container_Def($define));
        $this->$alias = $Container->getComponent("Renderer_Simple_{$alias}");
        return $this->$alias;
    }
    
    
    
    
    
    /**
     * Setters.
     * @implements
     */
    public function setAction($Action)
    {
        $Action->beforeRenderer();
        $this->Action = $Action;
        $this->assign('Action', $Action);
        foreach(get_object_vars($Action) as $_key => $_val){
            if(!preg_match('/^_/', $_key)){
                $this->assign($_key, $_val);
            }
        }
    }
    public function setErrorList($ErrorList)
    {
        $this->ErrorList = $ErrorList;
        $this->assign('ErrorList', $ErrorList);
    }
    public function setRequest($Request)
    {
        $this->Request = $Request;
        $this->assign('Request', $Request);
        $this->assign('request', $Request->getParameters());
    }
    public function setCookie($Cookie)
    {
        $this->Cookie = $Cookie;
        $this->assign('Cookie', $Cookie);
        $this->assign('cookie', $Cookie->getParameters());
    }
    public function setSession($Session)
    {
        $this->Session = $Session;
        $this->assign('Session', $Session);
        $this->assign('session', $Session->getParameters());
    }
    public function setServer($server)
    {
        $this->assign('server', $server);
    }
    public function setScriptName($script_name)
    {
        $this->assign('script_name', $script_name);
    }
    public function setToken($Token)
    {
        $this->Token = $Token;
        $this->assign('Token', $Token);
        $this->assign('token', array('name'=>$Token->getName(), 'value'=>$Token->getValue()));
    }
    
    
    
    
    
    /**
     * setEngine.
     * Renderer_SimpleはEngineを必要としないために何もしない。
     * @implements
     */
    protected function _setEngine()
    {
        
    }
}
