<?
/**
 * Action_Add_Component
 * 
 * Componentを生成する。
 * 
 * @package    Samurai
 * @subpackage Generator.Action.Add
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Add_Component extends Generator_Action
{
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //Usage
        if($this->_isUsage() || !$this->args) return 'usage';
        //入力チェック
        if(!$this->_checkInput()) return 'usage';
        //ループ(複数指定する事が可能)
        while($component_name = array_shift($this->args)){
            $params = array();
            $params['is_model'] = $this->Request->get('model');
            $component_name = strtolower($component_name);
            $component_file = $this->_addComponent($component_name, $params);
        }
    }
    
    
    /**
     * 入力チェック。
     * @access     private
     * @return     boolean エラーがあったかどうか
     */
    private function _checkInput()
    {
        //コンポーネント名のチェック
        foreach($this->args as $component_name){
            if(!preg_match('/^[a-zA-Z][a-zA-Z0-9_]+?$/', $component_name)){
                $this->ErrorList->add('component_name', "{$component_name} -> Component's name is Invalid. ([a-zA-Z0-9_])");
            }
        }
        return !$this->ErrorList->isExists();
    }
    
    
    /**
     * コンポーネントをを追加する。
     * @access     private
     * @param      string  $component_name   コンポーネント名
     * @param      array   $params           Rendererに渡される値
     */
    private function _addComponent($component_name, $params=array())
    {
        //Skeletonの決定
        $skeleton = $this->Generator->getSkeleton();
        //Generate
        list($result, $component_file) = $this->Generator->generate($component_name, $skeleton, $params);
        //成功
        if($result == $this->Generator->RESULT_SUCCESS){
            $this->_sendMessage("{$component_name} -> Successfully generated. [{$component_file}]");
        //既にある
        } elseif($result == $this->Generator->RESULT_ALREADY){
            $this->_sendMessage("{$component_name} -> Already exists. [{$component_file}] -> skip");
        } else {
            $this->_sendMessage("{$component_name} -> Failed.");
        }
        return $component_file;
    }
}
