<?
/**
 * Action_Add_Project
 * 
 * プロジェクトを生成する。
 * 
 * @package    Samurai
 * @subpackage Generator.Action.Add
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Add_Project extends Generator_Action
{
    private
        /** @var        string  プロジェクト名 */
        $project_name,
        /** @var        string  www/index.php */
        $www_index,
        /** @var        string  www/info.php */
        $www_info,
        /** @var        string  www/.htaccess */
        $www_htaccess,
        /** @var        string  www/samurai/samurai.css */
        $www_samurai_css,
        /** @var        string  close icon image */
        $www_samurai_image_close,
        /** @var        string  error icon image */
        $www_samurai_image_error,
        /** @var        string  info icon image */
        $www_samurai_image_info,
        /** @var        string  reload icon image */
        $www_samurai_image_reload,
        /** @var        string  toggle icon image */
        $www_samurai_image_toggle,
        /** @var        string  warning icon image */
        $www_samurai_image_warning;
    public
        /** @var        string  標準のレンダラー */
        $renderer = 'smarty',
        $renderer_suffix = 'tpl';
    public
        /** @var        object  GeneratorActionコンポーネント */
        $GeneratorAction,
        /** @var        object  GeneratorTemplateコンポーネント */
        $GeneratorTemplate,
        /** @var        object  GeneratorComponentコンポーネント */
        $GeneratorComponent,
        /** @var        object  GeneratorProjectコンポーネント */
        $GeneratorProject;
    
    
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //Usage
        if($this->_isUsage() || !$this->args) return 'usage';
        //入力チェック
        if(!$this->_checkInput()) return 'usage';
        //ディレクトリー群作成
        if(!$this->_generateDirectories()){
            return 'aborted';
        //デフォルトファイル群作成
        } else {
            $this->_generateDefaultFiles();
        }
        //wwwファイルのコピー
        $this->_copyWww();
        //終了
        $this->_sendMessage('');
        $this->_sendMessage('Generated Project ...!');
    }
    
    
    /**
     * 入力チェック。
     * @access     private
     * @return     boolean エラーがあったかどうか
     */
    private function _checkInput()
    {
        //プロジェクト名のチェック
        $this->project_name = array_shift($this->args);
        if(!preg_match('/^[a-z][a-z0-9_\-]*?$/', $this->project_name)){
            $this->ErrorList->add('project_name', "{$this->project_name} -> Project's name is Invalid. ([a-z0-9_-])");
        }
        //レンダラー名のチェック
        if(!preg_match('/smarty|phptal|simple/', $this->renderer)){
            $this->ErrorList->add('renderer', "{$this->renderer} -> Renderer's name is Invalid. (smarty|phptal|simple)");
        } else {
            Samurai_Config::set('generator.renderer.name', $this->renderer);
        }
        return !$this->ErrorList->isExists();
    }
    
    
    
    
    
    /**
     * ディレクトリー群の作成。
     * @access     private
     */
    private function _generateDirectories()
    {
        //基本Samurai_Dirの作成
        $samurai_dir = Samurai_Config::get('generator.directory.samurai');
        if(!is_dir($samurai_dir)){
            if(!$this->_confirm("May I create the directory ? ({$samurai_dir})")) return false;
            if(!mkdir($samurai_dir, 0755)) Samurai_Logger::fatal('%s -> Failed creating.', $samurai_dir);
        }
        //サブディレクトリ群の作成
        $dirs = array(
            array($samurai_dir.DS.'www', 0755),
            array($samurai_dir.DS.'www/samurai', 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.bin'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.log'), 0777),
            array($samurai_dir.DS.Samurai_Config::get('directory.temp'), 0777),
            array($samurai_dir.DS.Samurai_Config::get('directory.config'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.config').'/samurai', 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.config').'/renderer', 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.config').'/activegateway', 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.config').'/routing', 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.component'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.action'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.template'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.skeleton'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.locale'), 0755),
            array($samurai_dir.DS.Samurai_Config::get('directory.spec'), 0755),
        );
        foreach($dirs as $dir_info){
            $dir  = $dir_info[0];
            $mode = $dir_info[1];
            if(is_dir($dir)){
                $this->_sendMessage("{$dir} -> Already exists. -> skip");
                continue;
            }
            if(mkdir($dir, $mode)){
                $this->_sendMessage("{$dir} -> Successfuly generated.");
            } else {
                Samurai_Logger::error("{$dir} -> Failed creating.");
            }
            if(!chmod($dir, $mode)){
                Samurai_Logger::error("{$dir} -> Faild changing mode.");
            }
        }
        return true;
    }
    
    
    /**
     * 基本ファイル群を作成する。
     * @access     private
     */
    private function _generateDefaultFiles()
    {
        $this->_sendMessage('Creating default files ...');
        $this->_generateActions();
        $this->_generateTemplates();
        $this->_generateConfigs();
        $this->_generateWwws();
        $this->_sendMessage('Finished default file.');
    }
    //Action
    private function _generateActions()
    {
        list($result, $action_file) = $this->GeneratorAction->generate('index', $this->GeneratorAction->getSkeleton());
        $this->GeneratorAction->generate4Yaml($action_file, $this->GeneratorAction->getSkeleton($this->GeneratorAction->SKELETON_YAML),
                                                array('action_names'=>array('*'), 'action'=>false,'global'=>true),
                                                $this->GeneratorAction->YAML_GLOBAL);
        $this->GeneratorAction->generate4Yaml($action_file, $this->GeneratorAction->getSkeleton($this->GeneratorAction->SKELETON_YAML),
                                                array('action_names'=>array('index'), 'action'=>true,'global'=>false, 'template'=>'index.tpl'),
                                                $this->GeneratorAction->YAML_ACTION);
        $this->GeneratorAction->generate4Yaml($action_file, $this->GeneratorAction->getSkeleton($this->GeneratorAction->SKELETON_DICON),
                                                array('action_names'=>array('*')), $this->GeneratorAction->DICON_GLOBAL);
    }
    //Template
    private function _generateTemplates()
    {
        $this->GeneratorTemplate->generate('index.tpl', $this->GeneratorTemplate->getSkeleton());
    }
    //Config
    private function _generateConfigs()
    {
        //Samurai
        $this->GeneratorProject->generate4Config($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_SAMURAI_YAML),
                                                array(),
                                                $this->GeneratorProject->CONFIG_SAMURAI_YAML);
        $this->GeneratorProject->generate4Config($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_SAMURAI_DICON),
                                                array('renderer_name'=>$this->renderer),
                                                $this->GeneratorProject->CONFIG_SAMURAI_DICON);
        $this->GeneratorProject->generate4Config($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_SAMURAI_FRONTFILTER),
                                                array(),
                                                $this->GeneratorProject->CONFIG_SAMURAI_FRONTFILTER);
        //Renderer
        $this->GeneratorProject->generate4Config($this->project_name,
                                            $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_RENDERER_SMARTY),
                                            array(), $this->GeneratorProject->CONFIG_RENDERER_SMARTY);
        $this->GeneratorProject->generate4Config($this->project_name,
                                            $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_RENDERER_PHPTAL),
                                            array(), $this->GeneratorProject->CONFIG_RENDERER_PHPTAL);
        $this->GeneratorProject->generate4Config($this->project_name,
                                            $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_RENDERER_SIMPLE),
                                            array(), $this->GeneratorProject->CONFIG_RENDERER_SIMPLE);
        //ActiveGateway
        $this->GeneratorProject->generate4Config($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_AG),
                                                array(), $this->GeneratorProject->CONFIG_AG);
        //Routing
        $this->GeneratorProject->generate4Config($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_CONFIG_ROUTING),
                                                array(), $this->GeneratorProject->CONFIG_ROUTING);
        //Dot Samurai
        $this->GeneratorProject->generate4Dot($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_DOT_SAMURAI),
                                                array('renderer_name'=>$this->renderer,'renderer_suffix'=>$this->renderer_suffix),
                                                $this->GeneratorProject->DOT_SAMURAI);
    }
    //WWW
    private function _generateWwws()
    {
        //Index
        list($result, $this->www_index) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_INDEX),
                                                array(), $this->GeneratorProject->WWW_INDEX);
        //Info
        list($result, $this->www_info) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_INFO),
                                                array(), $this->GeneratorProject->WWW_INFO);
        //Htaccess
        list($result, $this->www_htaccess) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_HTACCESS),
                                                array(), $this->GeneratorProject->WWW_HTACCESS);
        //Samurai
        list($result, $this->www_samurai_css) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_CSS),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_CSS);
        list($result, $this->www_samurai_image_close) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_IMAGE_CLOSE),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_IMAGE_CLOSE);
        list($result, $this->www_samurai_image_error) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_IMAGE_ERROR),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_IMAGE_ERROR);
        list($result, $this->www_samurai_image_info) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_IMAGE_INFO),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_IMAGE_INFO);
        list($result, $this->www_samurai_image_reload) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_IMAGE_RELOAD),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_IMAGE_RELOAD);
        list($result, $this->www_samurai_image_toggle) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_IMAGE_TOGGLE),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_IMAGE_TOGGLE);
        list($result, $this->www_samurai_image_warning) = $this->GeneratorProject->generate4Www($this->project_name,
                                                $this->GeneratorProject->getSkeleton($this->GeneratorProject->SKELETON_WWW_SAMURAI_IMAGE_WARNING),
                                                array(), $this->GeneratorProject->WWW_SAMURAI_IMAGE_WARNING);
    }
    
    
    /**
     * www以下に作成されたファイルを、コピーするドキュメントルートにコピーする。
     * @access     private
     */
    private function _copyWww(){
        $document_root = sprintf('%s/%s', $this->dir_home, Samurai_Config::get('generator.directory.www'));
        if(is_dir($document_root) && $this->_confirm('May I copy the files of www onto the document root?')){
            $this->_copy($this->www_index,    sprintf('%s/%s', $document_root, basename($this->www_index)));
            $this->_copy($this->www_info,     sprintf('%s/%s', $document_root, basename($this->www_info)));
            $this->_copy($this->www_htaccess, sprintf('%s/%s', $document_root, basename($this->www_htaccess)));
            @mkdir($document_root.DS.'samurai', 0755);
            @chmod($document_root.DS.'samurai', 0755);
            $this->_copy($this->www_samurai_css,           sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_css)));
            $this->_copy($this->www_samurai_image_close,   sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_image_close)));
            $this->_copy($this->www_samurai_image_error,   sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_image_error)));
            $this->_copy($this->www_samurai_image_info,    sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_image_info)));
            $this->_copy($this->www_samurai_image_reload,  sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_image_reload)));
            $this->_copy($this->www_samurai_image_toggle,  sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_image_toggle)));
            $this->_copy($this->www_samurai_image_warning, sprintf('%s/samurai/%s', $document_root, basename($this->www_samurai_image_warning)));
        }
    }
    
    
    /**
     * 単純にコピーを行う。
     * 既に存在する場合は、上書きするか確認される。
     * @access     private
     */
    private function _copy($source, $dest){
        if(file_exists($dest)){
            if(!$this->_confirm("Overwrite ? ({$dest})")){
                $this->_sendMessage("{$dest} -> Aborted overwrite. -> skip");
                return;
            }
        }
        if(copy($source, $dest)){
            $this->_sendMessage("{$dest} -> Succesfuly copied.");
        } else {
            Samurai_Logger::error('Failed file copy. -> %s -> %s', array($source, $dest));
        }
    }
}
