<?
/**
 * Action_Make_Package
 * 
 * SamuraiFWのPEARパッケージを作成します。
 * 
 * @package    Samurai
 * @subpackage Generator.Make
 * @copyright  BEFOOL,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
include_once('PEAR.php');
include_once('PEAR/PackageFileManager2.php');
include_once('PEAR/PackageFileManager/File.php');
include_once('PEAR/PackageFile/v2/Validator.php');
include_once('PEAR/ChannelFile.php');
include_once('PEAR/Frontend.php');
include_once('PEAR/PackageFile/Generator/v2.php');
class Action_Make_Package extends Generator_Action
{
    public
        /** @var        string  状態(stable|beta|alpha) */
        $state = 'stable',
        /** @var        string  付加 */
        $postfix = '';
    private
        /** @var        string  一時ディレクトリ */
        $_tmp_dir = '/tmp/samurai',
        /** @var        string  作業ディレクトリ */
        $_work_dir = '/tmp/samurai/work',
        /** @var        string  リリースディレクトリ */
        $_release_dir = '/tmp/samurai/release',
        /** @var        string  ソースディレクトリ */
        $_src_dir = '';
    private
        /** @var        object  PackageFileManager2 */
        $Packager;
    
    
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //usage
        if($this->_isUsage()) return 'usage';
        //初期化
        $this->_init4make();
        
        //生成
        if(!$this->Request->get('customfile')){
            $this->_setOptions();
        } else {
            include($this->Request->get('customfile'));
        }
        $this->_generate();
    }
    
    
    /**
     * 生成。
     * @access     private
     */
    private function _generate()
    {
        $result = $this->Packager->generateContents();
        if(PEAR::isError($result)) exit($result->getMessage());
        if($this->Request->get('make')){
            $result = $this->Packager->writePackageFile();
            if(PEAR::isError($result)) exit($result->getMessage());
            $package = $this->_getPackageName() . '-' . $this->_getVersion();
            $archive = $package.'.tgz';
            chdir($this->_work_dir);
            shell_exec(sprintf('mv -f %s/package.xml ./', $this->_src_dir));
            shell_exec(sprintf('tar cvfz %s package.xml %s', $archive, $package));
            shell_exec(sprintf('cp -f %s %s/%s', $archive, $this->_release_dir, $archive));
            echo 'Successfuly generated ! -> '.$this->_release_dir.DS.$archive;
            echo "\n";
        } else {
            $result = $this->Packager->debugPackageFile();
            if(PEAR::isError($result)) exit($result->getMessage());
        }
    }
    
    
    /**
     * 設定。
     * @access     private
     */
    private function _setOptions()
    {
        $options = array(
            'baseinstalldir' => 'Samurai',
            'packagedirectory' => SAMURAI_DIR,
            'filelistgenerator' => 'file',
            'license' => 'The modified BSD License',
            'changelogoldtonew' => false,
            'roles' => array(
                '*' => 'php',
            ),
            'exceptions' => array(
                'bin/samurai.sh' => 'script',
                'bin/samurai.bat' => 'script',
            ),
            'installexceptions' => array(
                'bin/samurai.sh' => '/',
                'bin/samurai.bat' => '/'
            ),
            'ignore' => array(
                '.svn/',
                'package.xml',
            ),
            'addhiddenfiles' => true,
        );
        $result = $this->Packager->setOptions($options);
        if(PEAR::isError($result)) exit($result->getMessage());
        
        $this->Packager->setPackage('Samurai');
        $this->Packager->setSummary('Samurai PHP Framework Package');
        $this->Packager->setDescription('Samurai is PHP Web Application Framework extends Maple3.');
        $this->Packager->setChannel('pear.befool.co.jp');
        $this->Packager->setAPIVersion($this->_getVersion());
        $this->Packager->setAPIStability($this->state);
        $this->Packager->setReleaseVersion($this->_getVersion());
        $this->Packager->setReleaseStability($this->state);
        $this->Packager->setNotes(file_get_contents($this->_src_dir.'/CHANGES'));
        $this->Packager->setLicense('The modified BSD License', 'http://opensource.org/licenses/bsd-license.php');
        
        $this->Packager->setPackageType('php');
        $this->Packager->addRole('*', 'php');
        $this->Packager->addReplacement('bin/samurai.sh', 'pear-config', '@PEAR-DIR@', 'php_dir');
        $this->Packager->addReplacement('bin/samurai.sh', 'pear-config', '@PHP-BIN@',  'php_bin');
        $this->Packager->addReplacement('bin/samurai.bat', 'pear-config', '@PEAR-DIR@', 'php_dir');
        $this->Packager->addReplacement('bin/samurai.bat', 'pear-config', '@PHP-BIN@',  'php_bin');
        
        $this->Packager->addMaintainer('lead', 'satoshi.kiuchi', 'Satoshi Kiuchi', 'satoshi.kiuchi@befool.co.jp');
        $this->Packager->addMaintainer('developer', 'yuki.kuwabara', 'Yuki Kuwabara', 'yuki.kuwabara@befool.co.jp');
        $this->Packager->addMaintainer('developer', 'hisayuki.mashimo', 'Hisayuki Mashimo', 'hisayuki.mashimo@befool.co.jp');
        $this->Packager->addMaintainer('developer', 'yorimichi.ebina', 'Yorimichi Ebina', 'yorimichi.ebina@befool.co.jp');
        
        $this->Packager->addRelease();
        $this->Packager->setOSInstallCondition('windows');
        $this->Packager->addInstallAs('bin/samurai.bat', 'samurai.bat');
        $this->Packager->addIgnoreToRelease('bin/samurai.sh');
        $this->Packager->addRelease();
        $this->Packager->addInstallAs('bin/samurai.sh', 'samurai');
        $this->Packager->addIgnoreToRelease('bin/samurai.bat');
        
        //依存関係解消
        $this->Packager->setPhpDep('5.1.0');
        $this->Packager->setPearinstallerDep('1.4.11');
        $this->Packager->addPackageDepWithChannel('required', 'Crypt_Blowfish', 'pear.php.net');
        $this->Packager->addPackageDepWithChannel('required', 'PHPSpec', 'pear.befool.co.jp');
    }
    
    
    
    
    
    /**
     * パッケージ名を取得
     * @access     private
     * @return     string  パッケージ名
     */
    private function _getPackageName()
    {
        return $this->Request->get('package', 'Samurai');
    }
    
    
    /**
     * バージョンを取得する。
     * @access     private
     * @return     string  バージョン文字列
     */
    private function _getVersion()
    {
        $version = $this->Request->get('version', Samurai::VERSION);
        return $version.$this->postfix;
    }
    
    
    /**
     * 初期化。
     * @access     private
     */
    private function _init4make()
    {
        //補完
        if(!is_dir($this->_tmp_dir)){
            mkdir($this->_tmp_dir);
        }
        if(!is_dir($this->_work_dir)){
            mkdir($this->_work_dir);
        }
        if(!is_dir($this->_release_dir)){
            mkdir($this->_release_dir);
        }
        //移動
        $this->_src_dir = $this->Request->get('src_dir', SAMURAI_DIR);
        chdir($this->_src_dir);
        //削除
        $dir = $this->_getPackageName() . '-' . $this->_getVersion();
        @unlink($this->_work_dir.'/package.xml');
        if(is_dir($this->_work_dir.DS.$dir)){
            shell_exec(sprintf('rm -rf %s', $this->_work_dir.DS.$dir));
        }
        shell_exec(sprintf('cp -a %s %s', $this->_src_dir, $this->_work_dir.DS.$dir));
        //FileManager
        $this->Packager = new PEAR_PackageFileManager2();
    }
}
