<?
/**
 * Generator_Generator_Template
 * 
 * Template用Generator。
 * 
 * @package    Samurai
 * @subpackage Generator
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Generator_Generator_Template extends Generator
{
    public
        /** @var        string  WEB用スケルトン名(smarty) */
        $SKELETON_WEB_SMARTY = 'template/web.smarty.skeleton.php',
        /** @var        string  WEB用スケルトン名(phptal) */
        $SKELETON_WEB_PHPTAL = 'template/web.phptal.skeleton.php',
        /** @var        string  WEB用スケルトン名(simple) */
        $SKELETON_WEB_SIMPLE = 'template/web.simple.skeleton.php',
        /** @var        string  CLI用スケルトン名(smarty) */
        $SKELETON_CLI_SMARTY = 'template/cli.smarty.skeleton.php',
        /** @var        string  CLI用スケルトン名(simple) */
        $SKELETON_CLI_SIMPLE = 'template/cli.simple.skeleton.php',
        /** @var        int     ブラウザWEB */
        $BROWSER_WEB = 1,
        /** @var        int     ブラウザCLI */
        $BROWSER_CLI = 2;
    
    
    /**
     * Generateトリガーメソッド。
     * @access     public
     */
    public function generate($template_name, $skeleton, $params=array())
    {
        //ローカライズ
        $template_dir = sprintf('%s/%s', Samurai_Config::get('generator.directory.samurai'), Samurai_Config::get('generator.directory.template'));
        $template_file = sprintf('%s/%s', $template_dir, $template_name);
        //ジェネレイト
        $params['template_names'] = preg_split('/[_\/]/', preg_replace('/\.tpl$/', '', $template_name));
        $params['output_code'] = Samurai_Config::get('generator.encoding.output');
        if(file_exists($template_dir) && is_dir($template_dir)){
            $result = $this->_generate($template_file, $skeleton, $params);
        } else {
            $result = $this->RESULT_IGNORE;
        }
        return array($result, $template_file);
    }
    
    
    
    
    
    /**
     * スケルトンの取得。
     * @access     public
     * @param      string  $filename   スケルトン名
     * @return     string  スケルトン名
     */
    public function getSkeleton($filename=NULL)
    {
        if(!$filename){
            $filename = 'SKELETON_WEB_'.strtoupper(Samurai_Config::get('generator.renderer.name'));
            $filename = $this->{$filename};
        }
        return parent::getSkeleton($filename);
    }
}
