<?
/**
 * dBug_DumpHelper
 * 
 * 配列、オブジェクトから循環参照を取り除くためのクラス。
 * dBugとは無関係です。
 * 
 * @package    Samurai
 * @subpackage Library.dBug
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class dBug_DumpHelper
{
    private
        /** @var        array   参照を保持 */
        $_ref_stack = array();
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * 循環参照を取り除いたものを返却。
     * @access     public
     * @param      mixed   $var   対象変数
     * @return     mixed   結果
     */
    public function removeCircularReference($var, $depth=0)
    {
        //初期化
        $result = NULL;
        //オブジェクトの場合
        if(is_object($var)){
            if($depth > 5) return '5 over nest...';
            if($this->_push($var)){
                $result = clone $var;
                foreach(array_keys(get_object_vars($var)) as $_val){
                    $temp = $this->removeCircularReference($var->$_val, $depth + 1);
                    $result->$_val =& $temp;
                    unset($temp);
                }
                $this->_pop();
            } else {
                $result = $this->_getSubstituteFor($var);
            }
        //配列の場合
        } elseif(is_array($var)){
            if($this->_push($var)){
                $result = array();
                foreach(array_keys($var) as $_val){
                    $temp = $this->removeCircularReference($var[$_val], $depth + 1);
                    $result[$_val] =& $temp;
                    unset($temp);
                }
                $this->_pop();
            } else {
                $result = $this->_getSubstituteFor($var);
            }
        //なんでもない場合
        } else {
            $result = $var;
        }
        return $result;
    }
    
    
    /**
     * 循環しているobject or arrayの代替表現を返す。
     * @access     private
     * @param      mixed   $var   対象変数
     * @return     string  代替文字列
     */
    private function _getSubstituteFor($var){
        if(is_object($var)){
            return sprintf('&object(%s)', get_class($var));
        } elseif(is_array($var)) {
            return '&array';
        } else {
            return '&string';
        }
    }
    
    
    
    
    
    /**
     * 参照をスタックに積む。
     * 既にスタック内に同一の参照が存在する場合、スタックには積まずfalseを返す。
     * @access     private
     * @param      mixed   $var   対象変数
     * @return     boolean スタックできたかどうか
     */
    private function _push(&$var)
    {
        $var_type = gettype($var);
        foreach($this->_ref_stack as $_key => $_val){
            if($var_type == gettype($this->_ref_stack[$_key])
                && $this->isReference($var, $this->_ref_stack[$_key])){
                return false;
            }
        }
        $this->_ref_stack[] =& $var;
        return true;
    }
    
    
    /**
     * スタックから参照を取り除く。
     * @access     private
     */
    private function _pop()
    {
        array_pop($this->_ref_stack);
    }
    
    
    /**
     * スタックのリセット。
     * 厳密には処理が終わった時点でスタックは空になっているはずだが、念のため。
     * @access     public
     */
    public function reset()
    {
        $this->_ref_stack = array();
    }
    
    
    
    
    
    /**
     * 参照かどうかを判断する。
     * @access     public
     * @param      mixed   $first    第一引数
     * @param      mixed   $second   第二引数
     * @return     boolean 参照かどうか
     */
    public function isReference(&$first, &$second)
    {
        //オブジェクトの場合
        if(is_object($first)){
            return $first === $second;
        }
        //その他の場合
        $temp = $first;
        $first = uniqid('dumphelper');
        $is_ref = $first === $second;
        $first = $temp;
        return $is_ref;
    }
}
