/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Environments;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.Rounding;
import com.sanpudo.formula.Value;
import java.math.BigDecimal;
import java.util.regex.Pattern;

class Constant
extends Value {
    String name;
    Environments environments;
    static final String regex = "[a-zA-Z]\\w*";
    static final String regexParam = "([a-zA-Z]\\w*)|(\\$\\d)";
    static Pattern pattern = Pattern.compile("[a-zA-Z]\\w*");
    static Pattern patternParam = Pattern.compile("([a-zA-Z]\\w*)|(\\$\\d)");

    Constant(String formula, int location, String name, Environments environments) {
        super(formula, location);
        this.name = name;
        this.environments = environments;
    }

    String strToken() {
        return this.name;
    }

    static boolean isValidName(String name, boolean allowParam) {
        if (allowParam) {
            return patternParam.matcher(name).matches();
        }
        return pattern.matcher(name).matches();
    }

    double value() throws FormulaEvaluatorException {
        try {
            if (this.environments.userDefine.containsKey(this.name)) {
                return Double.parseDouble(this.environments.userDefine.get(this.name));
            }
            if (Environments.predefine.containsKey(this.name)) {
                return Double.parseDouble(Environments.predefine.get(this.name));
            }
            throw new FormulaEvaluatorException("Library internal error", this.strToken(), this.location);
        }
        catch (NumberFormatException e) {
            throw new FormulaEvaluatorException("Library internal error", (Throwable)e, this.strToken(), this.location);
        }
    }

    BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
        try {
            if (this.environments.userDefine.containsKey(this.name)) {
                return rounding.everyRound(new BigDecimal(this.environments.userDefine.get(this.name)));
            }
            if (Environments.predefine.containsKey(this.name)) {
                return rounding.everyRound(new BigDecimal(Environments.predefine.get(this.name)));
            }
            throw new FormulaEvaluatorException("Library internal error", this.strToken(), this.location);
        }
        catch (Exception e) {
            throw new FormulaEvaluatorException("Library internal error", (Throwable)e, this.strToken(), this.location);
        }
    }
}

